<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['access'] < 2) { header("Location: /profile.php"); exit; }
require_once __DIR__ . '/../system/head.php';

$msg = '';
if (isset($_POST['ban_user'])) {
    $nick = trim($_POST['nick'] ?? '');
    $minutes = (int)($_POST['minutes'] ?? 0);
    $reason = trim($_POST['reason'] ?? 'Нарушение правил');
    $ban_until = time() + ($minutes * 60);

    $stmt = $db->prepare("SELECT id FROM users WHERE login = ? LIMIT 1");
    $stmt->execute([$nick]);
    $target = $stmt->fetch();

    if ($target && $target['id'] != $user['id']) {
        $db->prepare("UPDATE users SET ban_time = ?, ban_reason = ? WHERE id = ?")
           ->execute([$ban_until, $reason, $target['id']]);
        
        // ЗАПИСЬ В ЛОГИ
        admin_log($db, (int)$user['id'], (int)$target['id'], 'BAN', "Забанил на $minutes мин. Причина: $reason");
        
        $msg = "<div style='color:#2ecc71; text-align:center; padding:10px;'>Игрок забанен!</div>";
    } else {
        $msg = "<div style='color:#ff4d4d; text-align:center; padding:10px;'>Ошибка ника!</div>";
    }
}
?>
<div style="max-width:400px; margin:20px auto; background:#161b22; padding:20px; border-radius:15px; border:1px solid #30363d;">
    <h3 style="text-align:center; color:#ff4d4d;">🔨 Тюрьма</h3>
    <?= $msg ?>
    <form method="post">
        <input type="text" name="nick" placeholder="Ник" required style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <input type="number" name="minutes" placeholder="Минуты" required style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <input type="text" name="reason" placeholder="Причина" style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <button type="submit" name="ban_user" style="width:100%; padding:12px; background:#da3633; border:none; color:#fff; border-radius:8px; font-weight:bold;">ОСУДИТЬ</button>
    </form>
    <br><a href="index.php" style="color:#8b949e; text-decoration:none; display:block; text-align:center;">← Назад</a>
</div>
<?php require_once __DIR__ . '/../system/foot.php'; ?>
