<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['access'] < 3) {
    header("Location: /"); exit;
}

// Обработка добавления новой локации
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_loc'])) {
    $name = trim($_POST['name']);
    $desc = trim($_POST['desc']);
    $res_node = trim($_POST['res_node'] ?: '');
    $res_item = trim($_POST['res_item'] ?: '');

    if ($name) {
        $stmt = $db->prepare("INSERT INTO `locations` (name, description, resource_node, resource_item) VALUES (?, ?, ?, ?)");
        $stmt->execute([$name, $desc, $res_node, $res_item]);
        header("Location: admin_locations.php?ok=1");
        exit;
    }
}

// Обработка удаления
if (isset($_GET['del'])) {
    $db->prepare("DELETE FROM `locations` WHERE id = ?")->execute([(int)$_GET['del']]);
    header("Location: admin_locations.php");
    exit;
}

require_once __DIR__ . '/../system/head.php';
$locs = $db->query("SELECT * FROM `locations` ORDER BY id ASC")->fetchAll();
?>

<div class="admin-dashboard" style="max-width: 500px; margin: 0 auto; padding: 10px;">
    <div class="admin-title-block" style="text-align: center; margin-bottom: 20px;">
        <span class="admin-badge-top" style="background:var(--accent); color:#000; padding:3px 10px; border-radius:5px; font-size:10px; font-weight:900;">WORLD EDITOR 2026</span>
        <h2 style="color:#fff; margin-top:10px;">🗺️ Картография</h2>
    </div>

    <!-- ФОРМА СОЗДАНИЯ -->
    <div style="background: #161b22; border: 1px solid #30363d; padding: 15px; border-radius: 16px; margin-bottom: 20px;">
        <form method="POST">
            <label style="color:gray; font-size:0.7rem; font-weight:bold; text-transform:uppercase;">Название локации</label>
            <input type="text" name="name" placeholder="Напр: Ледяная Пещера" required style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:10px; border-radius:8px; margin: 5px 0 15px 0; box-sizing:border-box;">

            <label style="color:gray; font-size:0.7rem; font-weight:bold; text-transform:uppercase;">Описание</label>
            <textarea name="desc" placeholder="Краткое описание местности..." style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:10px; border-radius:8px; margin: 5px 0 15px 0; box-sizing:border-box;"></textarea>

            <div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px; margin-bottom:15px;">
                <div>
                    <label style="color:gray; font-size:0.6rem;">РЕСУРС (Node)</label>
                    <input type="text" name="res_node" placeholder="Куст малины" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:8px; border-radius:6px; box-sizing:border-box;">
                </div>
                <div>
                    <label style="color:gray; font-size:0.6rem;">ВЫПАДАЕТ (Item)</label>
                    <input type="text" name="res_item" placeholder="Ягода" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:8px; border-radius:6px; box-sizing:border-box;">
                </div>
            </div>

            <button type="submit" name="add_loc" style="width:100%; background:var(--accent); color:#000; border:none; padding:12px; border-radius:10px; font-weight:bold; cursor:pointer;">СОЗДАТЬ ЛОКАЦИЮ</button>
        </form>
    </div>

    <!-- СПИСОК ЛОКАЦИЙ -->
    <h3 style="color:#fff; font-size:1rem; margin-bottom:10px;">Список земель</h3>
    <?php foreach($locs as $l): ?>
        <div style="background:#161b22; border:1px solid #30363d; padding:12px; border-radius:12px; margin-bottom:8px; display:flex; justify-content:space-between; align-items:center;">
            <div>
                <div style="color:#fff; font-weight:bold; font-size:0.9rem;">ID: <?= $l['id'] ?> | <?= htmlspecialchars($l['name']) ?></div>
                <div style="color:gray; font-size:0.7rem;">
                    <?= $l['resource_node'] ? "🌿 Ресурс: {$l['resource_node']}" : "💨 Нет ресурсов" ?>
                </div>
            </div>
            <a href="?del=<?= $l['id'] ?>" onclick="return confirm('Удалить локацию? Монстры в ней останутся без дома!')" style="text-decoration:none;">🗑️</a>
        </div>
    <?php endforeach; ?>

    <div style="text-align: center; margin-top: 20px;">
        <a href="index.php" style="color:gray; text-decoration:none; font-size:0.8rem;">← Назад в админку</a>
    </div>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
