<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

// Доступ только для [Адм]
if (!$user || (int)$user['access'] < 3) {
    header("Location: /profile.php");
    exit;
}

require_once __DIR__ . '/../system/head.php';

// Получаем логи с именами админов и целей
$query = "
    SELECT l.*, a.login as admin_name, t.login as target_name 
    FROM admin_logs l
    LEFT JOIN users a ON l.admin_id = a.id
    LEFT JOIN users t ON l.target_id = t.id
    ORDER BY l.id DESC LIMIT 50
";
$logs = $db->query($query)->fetchAll();
?>

<div class="admin-container">
    <div class="admin-header">
        <span class="admin-badge" style="background:#58a6ff; color:#fff;">ARCHIVE 2026</span>
        <h2>Логи правосудия</h2>
    </div>

    <div class="admin-card logs-panel">
        <?php if (!$logs): ?>
            <p style="text-align:center; color:#5c636a; padding:20px;">История пуста</p>
        <?php else: ?>
            <?php foreach ($logs as $log): ?>
                <div class="log-entry">
                    <div class="log-top">
                        <span class="l-type"><?= htmlspecialchars($log['action_type']) ?></span>
                        <span class="l-date"><?= date("d.m H:i:s", (int)$log['created_at']) ?></span>
                    </div>
                    <div class="log-text">
                        <b style="color:#fff;"><?= htmlspecialchars($log['admin_name'] ?? 'System') ?></b> 
                        <span style="color:#8b949e;">➜</span> 
                        <?= htmlspecialchars($log['details']) ?> 
                        <?php if ($log['target_name']): ?>
                            для <b><?= htmlspecialchars($log['target_name']) ?></b>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <a href="index.php" class="back-link">← Назад в меню</a>
</div>

<style>
    .admin-container { max-width: 500px; margin: 0 auto; padding: 10px; animation: fadeIn 0.3s ease; }
    .admin-header { text-align: center; margin-bottom: 20px; }
    .admin-badge { font-size: 10px; padding: 3px 10px; border-radius: 5px; font-weight: 900; }
    
    .admin-card { background: #161b22; border: 1px solid #30363d; border-radius: 16px; overflow: hidden; }
    
    .log-entry { 
        padding: 12px 15px; 
        border-bottom: 1px solid #21262d; 
        font-size: 0.85rem; 
    }
    .log-entry:last-child { border-bottom: none; }
    
    .log-top { display: flex; justify-content: space-between; margin-bottom: 6px; }
    .l-type { 
        background: #21262d; color: #ffc107; 
        padding: 2px 6px; border-radius: 4px; font-size: 0.7rem; font-weight: bold; text-transform: uppercase;
    }
    .l-date { color: #5c636a; font-size: 0.75rem; }
    
    .log-text { color: #e6edf3; line-height: 1.4; }
    .back-link { display: block; text-align: center; color: #8b949e; text-decoration: none; margin-top: 20px; font-size: 0.9rem; }
</style>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
