<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

// Проверка доступа (Админ уровень 3+)
if (!$user || (int)$user['access'] < 3) {
    header("Location: /profile.php");
    exit;
}

// Логика добавления монстра
if (isset($_POST['add_mob'])) {
    $db->prepare("INSERT INTO mobs (name, level, hp, atk, exp, loc_id) VALUES (?, ?, ?, ?, ?, ?)")
       ->execute([
           trim($_POST['name']), 
           (int)$_POST['lvl'], 
           (int)$_POST['hp'], 
           (int)$_POST['atk'], 
           (int)$_POST['exp'], 
           (int)$_POST['loc_id']
       ]);
    header("Location: admin_mobs.php?ok=1"); 
    exit;
}

// Логика удаления монстра
if (isset($_GET['del'])) {
    $db->prepare("DELETE FROM mobs WHERE id = ?")->execute([(int)$_GET['del']]);
    header("Location: admin_mobs.php?deleted=1");
    exit;
}

require_once __DIR__ . '/../system/head.php';

// Получаем данные для списков
$locations = $db->query("SELECT id, name FROM locations ORDER BY id ASC")->fetchAll();
$mobs = $db->query("SELECT m.*, l.name as loc_name FROM mobs m LEFT JOIN locations l ON m.loc_id = l.id ORDER BY m.level ASC")->fetchAll();
?>

<div class="admin-dashboard">
    <div class="admin-title-block">
        <span class="admin-badge-top">BESTIARY EDITOR 2026</span>
        <h1>Управление монстрами</h1>
    </div>

    <?php if (isset($_GET['ok'])): ?>
        <div style="background: rgba(46, 204, 113, 0.2); color: #2ecc71; padding: 12px; border-radius: 12px; margin-bottom: 15px; text-align: center; font-size: 0.8rem; border: 1px solid rgba(46, 204, 113, 0.3);">
            ✅ Монстр успешно создан и выпущен в мир!
        </div>
    <?php endif; ?>

    <!-- ФОРМА ДОБАВЛЕНИЯ -->
    <div class="admin-menu-list" style="margin-bottom: 25px;">
        <div style="background: #161b22; border: 1px solid #30363d; padding: 20px; border-radius: 16px;">
            <span class="stat-label" style="margin-bottom: 15px; display: block; color: var(--accent);">Создать новую сущность</span>
            
            <form method="POST">
                <label class="stat-label">Имя существа</label>
                <input type="text" name="name" placeholder="Напр: Пещерный Огр" required style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:12px; border-radius:10px; margin-bottom:15px; box-sizing:border-box;">
                
                <label class="stat-label">Место обитания</label>
                <select name="loc_id" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:12px; border-radius:10px; margin-bottom:15px;">
                    <?php foreach($locations as $l): ?>
                        <option value="<?= $l['id'] ?>">📍 <?= htmlspecialchars($l['name']) ?></option>
                    <?php endforeach; ?>
                </select>

                <div style="display:grid; grid-template-columns:1fr 1fr; gap:10px;">
                    <div>
                        <label class="stat-label">Уровень</label>
                        <input type="number" name="lvl" value="1" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:10px; border-radius:10px; box-sizing:border-box;">
                    </div>
                    <div>
                        <label class="stat-label">Здоровье (HP)</label>
                        <input type="number" name="hp" value="100" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:10px; border-radius:10px; box-sizing:border-box;">
                    </div>
                    <div>
                        <label class="stat-label">Атака (ATK)</label>
                        <input type="number" name="atk" value="10" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:10px; border-radius:10px; box-sizing:border-box;">
                    </div>
                    <div>
                        <label class="stat-label">Опыт (EXP)</label>
                        <input type="number" name="exp" value="25" style="width:100%; background:#0d1117; color:#fff; border:1px solid #30363d; padding:10px; border-radius:10px; box-sizing:border-box;">
                    </div>
                </div>

                <button type="submit" name="add_mob" style="width:100%; background:var(--accent); color:#000; font-weight:900; border:none; padding:14px; border-radius:12px; margin-top:20px; cursor:pointer; text-transform:uppercase; letter-spacing:1px;">
                    Призвать в мир
                </button>
            </form>
        </div>
    </div>

    <!-- СПИСОК МОНСТРОВ -->
    <span class="stat-label" style="margin-left: 10px; margin-bottom: 10px; display: block;">Текущий список (<?= count($mobs) ?>)</span>
    <div class="admin-menu-list">
        <?php if (!$mobs): ?>
            <div class="admin-menu-item" style="justify-content: center; color: gray;">Бестиарий пуст...</div>
        <?php endif; ?>

        <?php foreach ($mobs as $m): ?>
            <div class="admin-menu-item">
                <div class="menu-icon">👾</div>
                <div class="menu-info">
                    <span class="menu-title"><?= htmlspecialchars($m['name']) ?> <span style="color:var(--accent); font-size:0.7rem;">LVL <?= $m['level'] ?></span></span>
                    <span class="menu-desc">📍 <?= htmlspecialchars($m['loc_name'] ?? 'Без локации') ?> | ❤️ <?= $m['hp'] ?> | ⚔️ <?= $m['atk'] ?></span>
                </div>
                <a href="?del=<?= $m['id'] ?>" onclick="return confirm('Удалить монстра навсегда?')" style="text-decoration:none; padding: 5px;">🗑️</a>
            </div>
        <?php endforeach; ?>
    </div>

    <div style="text-align: center; margin-top: 30px; margin-bottom: 30px;">
        <a href="index.php" class="admin-menu-item" style="display:inline-flex; justify-content:center; width: auto; padding: 10px 25px; border-radius: 30px;">
            <span class="menu-title" style="font-size: 0.8rem;">🔙 Назад в управление</span>
        </a>
    </div>
</div>

<style>
    /* Используем стили из твоего основного файла админки */
    .admin-dashboard { max-width: 500px; margin: 0 auto; padding: 10px; animation: fadeInAdmin 0.5s ease; }
    .admin-title-block { text-align: center; margin-bottom: 25px; }
    .admin-badge-top { background: var(--accent); color: #000; font-size: 10px; padding: 3px 10px; border-radius: 5px; font-weight: 900; letter-spacing: 1px; }
    .admin-title-block h1 { margin: 10px 0 0 0; font-size: 1.5rem; color: #fff; text-transform: uppercase; }
    
    .stat-label { font-size: 0.65rem; color: #8b949e; text-transform: uppercase; margin-bottom: 5px; font-weight: bold; }
    
    .admin-menu-list { display: flex; flex-direction: column; gap: 10px; }
    .admin-menu-item { 
        display: flex; align-items: center; background: #161b22; 
        border: 1px solid #30363d; padding: 12px 15px; border-radius: 16px; 
        text-decoration: none;
    }
    .menu-icon { font-size: 1.4rem; margin-right: 15px; }
    .menu-info { flex-grow: 1; }
    .menu-title { display: block; color: #fff; font-weight: bold; font-size: 0.9rem; }
    .menu-desc { display: block; color: #8b949e; font-size: 0.7rem; margin-top: 2px; }
    
    select:focus, input:focus { outline: none; border-color: var(--accent) !important; }
</style>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
