<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['access'] < 3) { header("Location: /profile.php"); exit; }
require_once __DIR__ . '/../system/head.php';

$msg = '';
if (isset($_POST['give_res'])) {
    $target_nick = trim($_POST['nick'] ?? '');
    $gold = (int)($_POST['gold'] ?? 0);
    $silver = (int)($_POST['silver'] ?? 0);
    $exp = (int)($_POST['exp'] ?? 0);

    $stmt = $db->prepare("SELECT id FROM users WHERE login = ? LIMIT 1");
    $stmt->execute([$target_nick]);
    $target = $stmt->fetch();

    if ($target) {
        $db->prepare("UPDATE users SET gold = gold + ?, silver = silver + ?, exp = exp + ? WHERE id = ?")
           ->execute([$gold, $silver, $exp, $target['id']]);
        
        // ЗАПИСЬ В ЛОГИ
        admin_log($db, (int)$user['id'], (int)$target['id'], 'RESOURCES', "Выдал Gold: $gold, Silver: $silver, Exp: $exp");
        
        $msg = "<div style='color:#2ecc71; text-align:center; padding:10px;'>Ресурсы успешно выданы!</div>";
    } else {
        $msg = "<div style='color:#ff4d4d; text-align:center; padding:10px;'>Игрок не найден!</div>";
    }
}
?>
<div style="max-width:400px; margin:20px auto; background:#161b22; padding:20px; border-radius:15px; border:1px solid #30363d;">
    <h3 style="text-align:center; color:#ffc107;">🎁 Выдача ресурсов</h3>
    <?= $msg ?>
    <form method="post">
        <input type="text" name="nick" placeholder="Ник игрока" required style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <input type="number" name="gold" placeholder="Золото" style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <input type="number" name="silver" placeholder="Серебро" style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <input type="number" name="exp" placeholder="Опыт" style="width:100%; padding:12px; margin-bottom:10px; background:#0d1117; border:1px solid #333; color:#fff; border-radius:8px;">
        <button type="submit" name="give_res" style="width:100%; padding:12px; background:#238636; border:none; color:#fff; border-radius:8px; font-weight:bold;">ВЫДАТЬ</button>
    </form>
    <br><a href="index.php" style="color:#8b949e; text-decoration:none; display:block; text-align:center;">← Назад</a>
</div>
<?php require_once __DIR__ . '/../system/foot.php'; ?>
