<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

// Проверка доступа: только для высших чинов (access >= 3)
if (!$user || (int)$user['access'] < 3) {
    header("Location: /profile.php");
    exit;
}

require_once __DIR__ . '/../system/head.php';

// Сбор быстрой статистики для дашборда 2026
try {
    $total_players = (int)$db->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $online_count = (int)$db->query("SELECT COUNT(*) FROM users WHERE last_visit > " . (time() - 1800))->fetchColumn();
    $mobs_count = (int)$db->query("SELECT COUNT(*) FROM mobs")->fetchColumn();
    $news_count = (int)$db->query("SELECT COUNT(*) FROM news")->fetchColumn();
} catch (Exception $e) {
    $total_players = $online_count = $mobs_count = $news_count = 0;
}
?>

<style>
    .admin-dashboard { max-width: 500px; margin: 0 auto; padding: 10px; animation: fadeInAdmin 0.5s ease; }
    @keyframes fadeInAdmin { from { opacity: 0; transform: translateY(-5px); } to { opacity: 1; transform: translateY(0); } }

    .admin-title-block { text-align: center; margin-bottom: 20px; }
    .admin-badge-top { background: #ff4d4d; color: #fff; font-size: 10px; padding: 3px 10px; border-radius: 5px; font-weight: 900; letter-spacing: 1px; }
    .admin-title-block h1 { margin: 8px 0; font-size: 1.4rem; color: #fff; text-transform: uppercase; }

    /* Сетка статистики */
    .stats-grid-admin { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; margin-bottom: 20px; }
    .stat-card-mini { background: #161b22; border: 1px solid #30363d; padding: 10px; border-radius: 12px; display: flex; flex-direction: column; align-items: center; }
    .stat-label { font-size: 0.6rem; color: #8b949e; text-transform: uppercase; margin-bottom: 2px; }
    .stat-value { font-size: 1rem; font-weight: bold; color: #fff; }

    /* Список меню */
    .admin-menu-list { display: flex; flex-direction: column; gap: 8px; }
    .admin-menu-item { 
        display: flex; align-items: center; background: #161b22; 
        border: 1px solid #30363d; padding: 12px 15px; border-radius: 14px; 
        text-decoration: none; transition: 0.2s; 
    }
    .admin-menu-item:active { transform: scale(0.97); background: #1c2128; }
    .menu-icon { font-size: 1.5rem; margin-right: 15px; width: 30px; text-align: center; }
    .menu-info { flex-grow: 1; }
    .menu-title { display: block; color: #fff; font-weight: bold; font-size: 0.95rem; }
    .menu-desc { display: block; color: #8b949e; font-size: 0.7rem; }
    .menu-arrow { color: #30363d; font-size: 0.8rem; }

    .back-link { display: block; text-align: center; margin-top: 25px; color: #58a6ff; text-decoration: none; font-size: 0.85rem; font-weight: bold; }
</style>

<div class="admin-dashboard">
    <div class="admin-title-block">
        <span class="admin-badge-top">SYSTEM ADMIN 2026</span>
        <h1>Центр Управления</h1>
    </div>

    <!-- Статистика -->
    <div class="stats-grid-admin">
        <div class="stat-card-mini">
            <span class="stat-label">В сети</span>
            <span class="stat-value" style="color:#2ecc71;"><?= $online_count ?></span>
        </div>
        <div class="stat-card-mini">
            <span class="stat-label">Монстров</span>
            <span class="stat-value"><?= $mobs_count ?></span>
        </div>
    </div>

    <!-- Меню -->
    <div class="admin-menu-list">
        
        <!-- НОВОСТИ -->
        <a href="admin_news.php" class="admin-menu-item">
            <div class="menu-icon">🗞️</div>
            <div class="menu-info">
                <span class="menu-title">Новости</span>
                <span class="menu-desc">Управление лентой и категориями</span>
            </div>
            <span class="menu-arrow">➜</span>
        </a>

        <!-- МОНСТРЫ -->
        <a href="admin_mobs.php" class="admin-menu-item">
            <div class="menu-icon">👾</div>
            <div class="menu-info">
                <span class="menu-title">Бестиарий</span>
                <span class="menu-desc">Создание и баланс монстров</span>
            </div>
            <span class="menu-arrow">➜</span>
        </a>

        <!-- РЕСУРСЫ -->
        <a href="admin_res.php" class="admin-menu-item">
            <div class="menu-icon">🎁</div>
            <div class="menu-info">
                <span class="menu-title">Ресурсы</span>
                <span class="menu-desc">Выдача золота и опыта</span>
            </div>
            <span class="menu-arrow">➜</span>
        </a>

        <!-- БАНЫ -->
        <a href="admin_ban.php" class="admin-menu-item">
            <div class="menu-icon">🔨</div>
            <div class="menu-info">
                <span class="menu-title">Тюрьма</span>
                <span class="menu-desc">Бан и разбан нарушителей</span>
            </div>
            <span class="menu-arrow">➜</span>
        </a>

        <!-- ИГРОКИ -->
        <a href="admin_users.php" class="admin-menu-item">
            <div class="menu-icon">👤</div>
            <div class="menu-info">
                <span class="menu-title">Игроки</span>
                <span class="menu-desc">Правка характеристик и ников</span>
            </div>
            <span class="menu-arrow">➜</span>
        </a>

    </div>

    <a href="/main.php" class="back-link">← Вернуться в мир Хаты</a>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
