<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

// Если не авторизован — на выход
if (!$user) {
    header("Location: /login.php");
    exit;
}

$log = []; // Лог боя

// ЛОГИКА БОЯ
if (isset($_GET['attack'])) {
    $target_id = (int)$_GET['attack'];

    // Нельзя бить самого себя
    if ($target_id === $user['id']) {
        $log[] = "<span style='color:#e74c3c'>Вы не можете напасть на самого себя!</span>";
    } else {
        // Получаем данные противника
        $stmt = $db->prepare("SELECT * FROM users WHERE id = ? LIMIT 1");
        $stmt->execute([$target_id]);
        $enemy = $stmt->fetch();

        if (!$enemy) {
            $log[] = "Противник не найден.";
        } else {
            // Расчет параметров боя
            $damage = ($user['str'] * 2) - ($enemy['def'] / 2);
            if ($damage < 5) $damage = 5;

            // Шанс уклонения
            if (rand(1, 100) <= (($enemy['agi'] - $user['agi']) * 2)) {
                $log[] = "<span style='color:#f1c40f'>{$enemy['login']} уклонился!</span>";
            } else {
                // Наносим урон
                $new_hp = max(0, (int)$enemy['hp'] - (int)$damage);
                if ($new_hp === 0) {
                    // Победа
                    $exp = 10 + ($enemy['level'] * 2);
                    $db->prepare("UPDATE users SET exp = exp + ? WHERE id = ?")->execute([$exp, $user['id']]);
                    $db->prepare("UPDATE users SET hp = hp_max WHERE id = ?")->execute([$enemy['id']]); // Рес врага
                    $log[] = "<span style='color:#2ecc71'>Победа над {$enemy['login']}! +{$exp} опыта.</span>";
                    check_for_levelup($user);
                } else {
                    $db->prepare("UPDATE users SET hp = ? WHERE id = ?")->execute([$new_hp, $enemy['id']]);
                    $log[] = "Урон по {$enemy['login']}: <b style='color:#e74c3c'>-{$damage} HP</b>";
                }
            }
        }
    }
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    .arena-page { min-height: 100vh; background: #0f111a; padding: 20px; font-family: 'Inter', sans-serif; display: flex; flex-direction: column; gap: 15px; }
    .arena-card { background: #1c2128; border: 1px solid rgba(255, 255, 255, 0.05); border-radius: 20px; padding: 15px; display: flex; justify-content: space-between; align-items: center; }
    .user-name { color: #fff; font-weight: 800; font-size: 0.9rem; text-transform: uppercase; display: block; }
    .user-stats { color: #8b949e; font-size: 0.7rem; }
    .btn-attack { background: #e74c3c; color: #fff; padding: 10px 15px; border-radius: 12px; text-decoration: none; font-weight: 800; font-size: 0.7rem; text-transform: uppercase; }
    .log-box { background: rgba(255,255,255,0.02); padding: 15px; border-radius: 15px; font-size: 0.8rem; color: #eee; text-align: center; border: 1px solid rgba(255,255,255,0.05); }
</style>

<div class="arena-page">
    <h2 style="color:#fff; text-align:center; text-transform:uppercase;">Арена</h2>
    <?php if ($log) echo "<div class='log-box'>".implode('<br>', $log)."</div>"; ?>
    
    <?php
    // Время онлайн 30 минут = 1800 секунд
    $online_time = time() - 1800;
    $players = $db->prepare("SELECT * FROM users WHERE last_visit > ? AND id != ? ORDER BY level DESC");
    $players->execute([$online_time, $user['id']]);
    
    if ($players->rowCount() === 0): ?>
         <div style="text-align: center; color: #5b646e; padding: 40px;">Сейчас на арене пусто...</div>
    <?php else: ?>
        <?php foreach ($players->fetchAll() as $p): ?>
            <div class="arena-card">
                <div>
                    <span class="user-name"><?= $p['login'] ?> [<?= $p['level'] ?>]</span>
                    <span class="user-stats">HP: <?= $p['hp'] ?>/<?= $p['hp_max'] ?></span>
                </div>
                <a href="?attack=<?= $p['id'] ?>" class="btn-attack">Ударить</a>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <a href="/main.php" style="text-align:center; color:#5b646e; text-decoration:none; font-size:0.7rem; text-transform:uppercase; margin-top:20px;">Назад</a>
</div>
<?php require_once __DIR__ . '/system/foot.php'; ?>
