<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

// --- ЛОГИКА ЭКИПИРОВКИ ---
if (isset($_GET['equip'])) {
    $inv_id = (int)$_GET['equip'];
    
    // 1. Проверяем, существует ли этот предмет у игрока и является ли он оружием
    $check = $db->prepare("
        SELECT ui.id, i.type 
        FROM `user_inventory` ui 
        JOIN `items` i ON ui.item_id = i.id 
        WHERE ui.id = ? AND ui.user_id = ?
    ");
    $check->execute([$inv_id, $user['id']]);
    $item = $check->fetch();

    if ($item && $item['type'] === 'weapon') {
        // 2. Снимаем всё оружие с игрока
        $db->prepare("
            UPDATE `user_inventory` ui 
            JOIN `items` i ON ui.item_id = i.id 
            SET ui.is_equipped = 0 
            WHERE ui.user_id = ? AND i.type = 'weapon'
        ")->execute([$user['id']]);

        // 3. Надеваем выбранное
        $db->prepare("UPDATE `user_inventory` SET `is_equipped` = 1 WHERE `id` = ?")
           ->execute([$inv_id]);
           
        header("Location: bug.php?status=success");
        exit;
    }
}

require_once __DIR__ . '/system/head.php';

// --- ПОЛУЧЕНИЕ ИНВЕНТАРЯ ---
$inv_stmt = $db->prepare("
    SELECT ui.id as inv_id, ui.amount, ui.is_equipped, i.* 
    FROM `user_inventory` ui
    JOIN `items` i ON ui.item_id = i.id
    WHERE ui.user_id = ? AND ui.amount > 0
    ORDER BY ui.is_equipped DESC, i.type ASC
");
$inv_stmt->execute([$user['id']]);
$inventory = $inv_stmt->fetchAll();

// Расчет текущей мощи (база + бонус от шмота)
$bonus_atk = 0;
foreach($inventory as $slot) {
    if($slot['is_equipped']) $bonus_atk += (int)$slot['atk'];
}
$total_atk = $user['atk'] + $bonus_atk;
?>

<style>
    .bug-wrapper { padding: 10px; max-width: 500px; margin: 0 auto; }
    .stat-bar-total { background: #161b22; border: 1px solid var(--accent); border-radius: 12px; padding: 10px; margin-bottom: 15px; display: flex; justify-content: space-between; align-items: center; }
    .item-card { background: #1c2128; border: 1px solid #30363d; border-radius: 12px; padding: 12px; margin-bottom: 8px; display: flex; align-items: center; gap: 12px; }
    .equipped { border-color: var(--accent); box-shadow: 0 0 10px rgba(0, 212, 255, 0.1); }
    .item-icon { width: 45px; height: 45px; background: #0d1117; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; border: 1px solid rgba(255,255,255,0.05); }
    .btn-eq { background: var(--accent); color: #000; padding: 6px 12px; border-radius: 8px; text-decoration: none; font-size: 0.7rem; font-weight: bold; }
    .is-eq-label { color: var(--accent); font-size: 0.6rem; font-weight: 900; text-transform: uppercase; }
</style>

<div class="bug-wrapper">
    <div class="stat-bar-total">
        <span style="color:gray; font-size: 0.8rem;">⚔️ Ваша атака:</span>
        <span style="color:var(--accent); font-weight: 900; font-size: 1.1rem;"><?= $total_atk ?></span>
    </div>

    <?php foreach ($inventory as $item): ?>
        <div class="item-card <?= $item['is_equipped'] ? 'equipped' : '' ?>">
            <div class="item-icon"><?= $item['icon'] ?></div>
            <div style="flex-grow: 1;">
                <div style="color:#fff; font-weight:bold; font-size:0.9rem;"><?= htmlspecialchars($item['name']) ?></div>
                <div style="color:gray; font-size:0.7rem;">
                    <?= $item['type'] === 'weapon' ? "Урон: +{$item['atk']}" : "Ресурс" ?>
                </div>
            </div>
            
            <?php if ($item['type'] === 'weapon'): ?>
                <?php if ($item['is_equipped']): ?>
                    <span class="is-eq-label">Экипировано</span>
                <?php else: ?>
                    <a href="?equip=<?= $item['inv_id'] ?>" class="btn-eq">Надеть</a>
                <?php endif; ?>
            <?php else: ?>
                <span style="color:#30363d; font-size:0.8rem; font-weight:bold;">x<?= $item['amount'] ?></span>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
    
    <a href="/main.php" style="display:block; text-align:center; color:gray; text-decoration:none; margin-top:20px; font-size:0.8rem;">← В город</a>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
