<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user || !isset($_GET['id'])) {
    header("Location: /location.php");
    exit;
}

// 1. ПОЛУЧАЕМ ДАННЫЕ МОНСТРА
$mob_id = (int)$_GET['id'];
$stmt = $db->prepare("SELECT * FROM mobs WHERE id = ?");
$stmt->execute([$mob_id]);
$mob = $stmt->fetch();

if (!$mob) {
    header("Location: /location.php");
    exit;
}

// 2. РАСЧЕТ ПАРАМЕТРОВ ИГРОКА (База + Экипировка)
// Получаем бонус атаки от всех надетых предметов
$bonus_query = $db->prepare("
    SELECT SUM(i.atk) as total_bonus_atk 
    FROM `user_inventory` ui 
    JOIN `items` i ON ui.item_id = i.id 
    WHERE ui.user_id = ? AND ui.is_equipped = 1
");
$bonus_query->execute([$user['id']]);
$bonus = $bonus_query->fetch();

$bonus_atk = (int)($bonus['total_bonus_atk'] ?? 0);
$player_base_atk = (int)($user['atk'] ?? 5); // Если в базе нет стата, берем 5
$player_total_atk = $player_base_atk + $bonus_atk;

// 3. ИНИЦИАЛИЗАЦИЯ БОЯ
$p_hp = (int)$user['hp'];
$p_hp_max = (int)$user['hp_max'];
$m_hp = (int)$mob['hp'];
$m_atk = (int)$mob['atk'];

$log = [];
$rounds = 0;
$win = false;

// 4. ЦИКЛ БЫСТРОГО БОЯ (2026 Style)
while ($p_hp > 0 && $m_hp > 0 && $rounds < 50) {
    $rounds++;
    
    // Ход игрока
    $p_dmg = rand((int)($player_total_atk * 0.9), (int)($player_total_atk * 1.1));
    $m_hp -= $p_dmg;
    $log[] = "<span style='color:#fff'>Раунд $rounds:</span> Вы ударили на <b style='color:var(--accent)'>$p_dmg</b>.";

    if ($m_hp <= 0) {
        $win = true;
        break;
    }

    // Ход монстра
    $m_dmg = rand((int)($m_atk * 0.8), (int)($m_atk * 1.2));
    $p_hp -= $m_dmg;
    $log[] = "<span style='color:gray'>Раунд $rounds:</span> {$mob['name']} нанес вам <b style='color:#ff4d4d'>$m_dmg</b> урона.";

    if ($p_hp <= 0) {
        $win = false;
        break;
    }
}

// 5. ОБРАБОТКА РЕЗУЛЬТАТОВ
if ($win) {
    $gold_gain = rand(1, 5) * (int)$mob['level'];
    $exp_gain = (int)$mob['exp'];
    
    // Обновляем статы в БД (HP не может быть выше максимума)
    $db->prepare("UPDATE users SET hp = ?, gold = gold + ?, exp = exp + ? WHERE id = ?")
       ->execute([$p_hp, $gold_gain, $exp_gain, $user['id']]);
       
    $res_msg = "✨ Победа! Вы сокрушили врага!";
    $res_sub = "Получено: $gold_gain золота и $exp_gain опыта.";
    $res_color = "#2ecc71";
} else {
    // При смерти восстанавливаем HP до 50% и отправляем в начальную локу
    $revive_hp = (int)($p_hp_max * 0.5);
    $db->prepare("UPDATE users SET hp = ?, loc = 1 WHERE id = ?")
       ->execute([$revive_hp, $user['id']]);
       
    $res_msg = "💀 Вы повержены...";
    $res_sub = "Вы очнулись в безопасном месте, восстановив силы.";
    $res_color = "#ff4d4d";
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    .battle-scene { padding: 10px; max-width: 500px; margin: 0 auto; }
    .battle-header { background: #161b22; border: 1px solid #30363d; border-radius: 16px; padding: 20px; text-align: center; margin-bottom: 15px; border-bottom: 4px solid <?= $res_color ?>; }
    .battle-stats-info { display: flex; justify-content: space-around; margin-top: 10px; font-size: 0.8rem; color: #8b949e; }
    
    .log-container { background: #0d1117; border: 1px solid #30363d; border-radius: 12px; padding: 15px; height: 250px; overflow-y: auto; margin-bottom: 15px; box-shadow: inset 0 0 10px #000; }
    .log-entry { font-size: 0.85rem; margin-bottom: 6px; padding-bottom: 4px; border-bottom: 1px solid rgba(255,255,255,0.03); }
    
    .result-banner { text-align: center; padding: 15px; border-radius: 12px; background: rgba(255,255,255,0.03); margin-bottom: 15px; }
    .btn-return { display: block; text-align: center; background: <?= $res_color ?>; color: #000; padding: 15px; border-radius: 12px; text-decoration: none; font-weight: 900; text-transform: uppercase; letter-spacing: 1px; }
</style>

<div class="battle-scene">
    <div class="battle-header">
        <div style="font-size: 0.7rem; color: var(--accent); text-transform: uppercase; font-weight: bold;">Битва завершена</div>
        <h2 style="margin: 5px 0; color: #fff;"><?= htmlspecialchars($mob['name']) ?></h2>
        <div class="battle-stats-info">
            <span>Ваша атака: ⚔️ <?= $player_total_atk ?></span>
            <span>Раундов: ⏳ <?= $rounds ?></span>
        </div>
    </div>

    <div class="log-container" id="log">
        <?php foreach ($log as $entry): ?>
            <div class="log-entry">🔹 <?= $entry ?></div>
        <?php endforeach; ?>
    </div>

    <div class="result-banner">
        <div style="font-size: 1.2rem; font-weight: bold; color: <?= $res_color ?>;"><?= $res_msg ?></div>
        <div style="font-size: 0.85rem; color: #8b949e; margin-top: 5px;"><?= $res_sub ?></div>
    </div>

    <a href="/location.php" class="btn-return">Продолжить путь</a>
</div>

<script>
    // Автопрокрутка лога вниз
    const log = document.getElementById('log');
    log.scrollTop = log.scrollHeight;
</script>

<?php require_once __DIR__ . '/system/foot.php'; ?>
