<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!isset($user) || !$user || empty($user['clan_id'])) {
    header("Location: index.php");
    exit;
}

require_once __DIR__ . '/../system/head.php';

$stmt = $db->prepare("SELECT * FROM `clan_history` WHERE `clan_id` = ? ORDER BY `id` DESC LIMIT 50");
$stmt->execute([$user['clan_id']]);
$logs = $stmt->fetchAll();
?>

<div style="padding: 10px;">
    <div style="background: #222; padding: 12px; border-radius: 10px; margin-bottom: 10px; display:flex; justify-content:space-between; align-items:center;">
        <h4 style="margin:0; color:#fff;">📜 Журнал событий</h4>
        <a href="index.php" style="color:#3498db; text-decoration:none; font-size:0.8rem;">Назад</a>
    </div>

    <?php if (!$logs): ?>
        <div style="text-align:center; color:#666; padding:20px;">Событий не зафиксировано</div>
    <?php else: ?>
        <?php foreach ($logs as $log): ?>
            <div style="background:#1a1a1a; padding:10px; border-bottom:1px solid #222; font-size:0.85rem;">
                <small style="color:#555;"><?= date("H:i:s", $log['created_at']) ?></small> 
                <span style="color:#ccc;"><?= $log['message'] ?></span>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
