<?php
/**
 * Clan Index - Главная страница клана (2026 Style)
 */
declare(strict_types=1);

// Подключаем ядро (выход на уровень выше из папки /clan/)
require_once __DIR__ . '/../system/core.php';

// Проверка авторизации
if (!isset($user) || !$user) {
    header("Location: /index.php");
    exit;
}

$error = null;
$message = null;
$create_cost = 5000; // Цена создания клана

// --- ЛОГИКА СОЗДАНИЯ КЛАНА ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_clan']) && (int)$user['clan_id'] === 0) {
    $clan_name = trim((string)$_POST['clan_name']);
    
    if (mb_strlen($clan_name) < 3 || mb_strlen($clan_name) > 20) {
        $error = "🚫 Название должно быть от 3 до 20 символов!";
    } elseif ($user['silver'] < $create_cost) {
        $error = "🥈 Недостаточно серебра для основания ордена!";
    } else {
        // Проверка уникальности
        $check = $db->prepare("SELECT id FROM `clans` WHERE `name` = ?");
        $check->execute([$clan_name]);
        
        if ($check->fetch()) {
            $error = "🚫 Имя ордена уже занято!";
        } else {
            // Списание и создание
            $db->prepare("UPDATE `users` SET `silver` = `silver` - ? WHERE `id` = ?")->execute([$create_cost, $user['id']]);
            $db->prepare("INSERT INTO `clans` (`name`, `owner_id`, `created_at`) VALUES (?, ?, ?)")
               ->execute([$clan_name, $user['id'], time()]);
            
            $new_id = (int)$db->lastInsertId();
            $db->prepare("UPDATE `users` SET `clan_id` = ? WHERE `id` = ?")->execute([$new_id, $user['id']]);
            
            $user['clan_id'] = $new_id;
            $user['silver'] -= $create_cost;
            $message = "✨ Орден <b>$clan_name</b> успешно основан!";
        }
    }
}

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .clan-wrapper { padding: 12px; max-width: 500px; margin: 0 auto; font-family: 'Segoe UI', Roboto, sans-serif; }
    
    /* Карточка создания */
    .create-card { background: linear-gradient(145deg, #1e1e1e, #111); border: 1px solid #333; border-radius: 16px; padding: 20px; text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.5); }
    .create-input { width: 100%; padding: 12px; background: #000; border: 1px solid #444; border-radius: 8px; color: #fff; margin: 15px 0; text-align: center; font-size: 1rem; }
    .btn-gold { background: linear-gradient(to bottom, #f1c40f, #d4ac0d); color: #000; border: none; padding: 12px 25px; border-radius: 10px; font-weight: bold; cursor: pointer; width: 100%; transition: 0.2s; }
    .btn-gold:hover { transform: scale(1.02); filter: brightness(1.1); }

    /* Карточка клана */
    .clan-header { background: linear-gradient(135deg, #2c3e50, #000); border-radius: 16px 16px 0 0; padding: 25px; text-align: center; border: 1px solid #444; border-bottom: none; }
    .clan-name { font-size: 1.8rem; color: #f1c40f; text-transform: uppercase; letter-spacing: 2px; margin: 0; text-shadow: 0 2px 4px rgba(0,0,0,0.5); }
    .clan-stats { background: #1a1a1a; border: 1px solid #444; border-radius: 0 0 16px 16px; display: grid; grid-template-columns: 1fr 1fr; border-top: 1px solid #333; }
    .stat-box { padding: 15px; text-align: center; border-right: 1px solid #333; }
    .stat-box:last-child { border-right: none; }
    .stat-val { display: block; font-weight: bold; font-size: 1.1rem; color: #fff; }
    .stat-lbl { font-size: 0.7rem; color: #888; text-transform: uppercase; }

    /* Меню действий */
    .clan-menu { display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-top: 20px; }
    .menu-item { background: #222; border: 1px solid #333; padding: 15px; border-radius: 12px; text-align: center; text-decoration: none; color: #eee; transition: 0.2s; }
    .menu-item:hover { background: #2d2d2d; border-color: #555; }
    .menu-item i { display: block; font-size: 1.5rem; margin-bottom: 5px; }

    .alert { padding: 12px; border-radius: 10px; margin-bottom: 15px; text-align: center; font-size: 0.9rem; }
    .alert-danger { background: rgba(231, 76, 60, 0.15); color: #ff7675; border: 1px solid #e74c3c; }
    .alert-success { background: rgba(46, 204, 113, 0.15); color: #55efc4; border: 1px solid #2ecc71; }
</style>

<div class="clan-wrapper">

    <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
    <?php if ($message): ?><div class="alert alert-success"><?= $message ?></div><?php endif; ?>

    <?php if ((int)$user['clan_id'] === 0): ?>
        <!-- СОЗДАНИЕ КЛАНА -->
        <div class="create-card">
            <div style="font-size: 3rem; margin-bottom: 10px;">🛡</div>
            <h2 style="margin:0; color:#fff;">Основать Орден</h2>
            <p style="color:#888; font-size: 0.85rem;">Объедините героев под своим знаменем</p>
            
            <form method="POST">
                <input type="text" name="clan_name" class="create-input" placeholder="Название ордена..." maxlength="20" required>
                <div style="margin-bottom: 15px; color: #bdc3c7; font-weight: bold;">
                    Стоимость: 5,000 🥈
                </div>
                <button type="submit" name="create_clan" class="btn-gold">ВОЗДВИГНУТЬ ЗНАМЯ</button>
            </form>
        </div>
    <?php else: ?>
        <!-- МОЙ КЛАН -->
        <?php 
            $c_stmt = $db->prepare("SELECT * FROM `clans` WHERE `id` = ?");
            $c_stmt->execute([$user['clan_id']]);
            $clan = $c_stmt->fetch();
        ?>
        
        <div class="clan-header">
            <h1 class="clan-name"><?= htmlspecialchars($clan['name']) ?></h1>
            <div style="color: #888; font-size: 0.8rem; margin-top: 5px;">Уровень Ордена: <?= $clan['level'] ?></div>
        </div>
        
        <div class="clan-stats">
            <div class="stat-box">
                <span class="stat-val"><?= number_format((int)$clan['gold']) ?> 💰</span>
                <span class="stat-lbl">Золото</span>
            </div>
            <div class="stat-box">
                <span class="stat-val"><?= number_format((int)$clan['silver']) ?> 🥈</span>
                <span class="stat-lbl">Серебро</span>
            </div>
        </div>

        <div class="clan-menu">
            <a href="members.php" class="menu-item">
                <i>👥</i> Участники
            </a>
            <a href="donate.php" class="menu-item">
                <i>🪙</i> Казна
            </a>
            <a href="upgrades.php" class="menu-item">
                <i>🏛</i> Развитие
            </a>
            <a href="logs.php" class="menu-item">
                <i>📜</i> История
            </a>
        </div>

        <div style="text-align: center; margin-top: 25px;">
            <a href="/main.php" style="color: #666; text-decoration: none; font-size: 0.85rem;">← Вернуться в город</a>
        </div>
    <?php endif; ?>

</div>

<?php 
require_once __DIR__ . '/../system/foot.php'; 
?>
