<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['clan_id'] === 0) { header("Location: index.php"); exit; }

// Получаем информацию о клане для заголовка
$clan_stmt = $db->prepare("SELECT name FROM clans WHERE id = ?");
$clan_stmt->execute([$user['clan_id']]);
$clan_info = $clan_stmt->fetch();
$clan_name = $clan_info['name'] ?? 'Ваш клан';

// Получаем список участников
$stmt = $db->prepare("SELECT id, login, level, online FROM users WHERE clan_id = ? ORDER BY level DESC, online DESC");
$stmt->execute([$user['clan_id']]);
$members = $stmt->fetchAll();

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .members-wrapper { padding: 12px; max-width: 500px; margin: 0 auto; font-family: sans-serif; }
    .header-clan { background: #222; padding: 15px; border-radius: 12px; margin-bottom: 20px; text-align: center; border: 1px solid #333; }
    .member-item { background: #1a1a1a; padding: 12px; margin-bottom: 8px; border-radius: 8px; display: flex; justify-content: space-between; align-items: center; border: 1px solid #333; }
    .member-info { display: flex; align-items: center; }
    .member-name { color: #fff; font-weight: bold; margin-right: 10px; font-size: 0.95rem; }
    .member-level { color: #888; font-size: 0.8rem; }
    .member-status { font-size: 0.8rem; padding: 4px 8px; border-radius: 4px; }
    .status-online { background: rgba(0, 255, 0, 0.2); color: #00ff00; }
    .status-offline { background: rgba(255, 0, 0, 0.1); color: #ff4d4d; }
    .back-block { margin-top: 25px; text-align: center; }
    .back-link { background: #333; padding: 10px 20px; border-radius: 8px; color: #eee; text-decoration: none; display: inline-block; width: 100%; box-sizing: border-box; }
    .back-link:hover { background: #444; }
</style>

<div class="members-wrapper">
    <div class="header-clan">
        <h2 style="margin:0; color:#f1c40f;">👥 <?= htmlspecialchars($clan_name) ?></h2>
        <p style="margin:5px 0 0; color:#aaa;">Список участников: <?= count($members) ?> чел.</p>
    </div>
    
    <div class="members-list">
        <?php foreach ($members as $m): ?>
            <?php $isOnline = (time() - $m['online'] < 300); // 5 минут ?>
            <div class="member-item">
                <div class="member-info">
                    <span class="member-name"><?= htmlspecialchars($m['login']) ?></span>
                    <span class="member-level">[Ур. <?= $m['level'] ?>]</span>
                </div>
                <span class="member-status <?= $isOnline ? 'status-online' : 'status-offline' ?>">
                    <?= $isOnline ? 'В игре' : 'Не в сети' ?>
                </span>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Ссылка "Назад" в отдельном блоке внизу -->
    <div class="back-block">
        <a href="index.php" class="back-link">
            ← Вернуться в клан
        </a>
    </div>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
