<?php
/**
 * Upgrades.php - Улучшения ордена (2026 Style)
 */
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['clan_id'] === 0) {
    header("Location: index.php");
    exit;
}

// Получаем данные клана
$stmt = $db->prepare("SELECT * FROM `clans` WHERE `id` = ?");
$stmt->execute([$user['clan_id']]);
$clan = $stmt->fetch();

$error = null;
$message = null;

// Настройки цен (Базовая цена * уровень)
$base_cost = 10000;

// --- ЛОГИКА УЛУЧШЕНИЯ ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upgrade'])) {
    $type = (string)$_POST['type']; // 'upg_damage' или 'upg_exp'
    
    if (!in_array($type, ['upg_damage', 'upg_exp'])) {
        $error = "🚫 Неизвестный тип постройки.";
    } else {
        $current_lvl = (int)$clan[$type];
        $cost = ($current_lvl + 1) * $base_cost;

        if ($clan['owner_id'] != $user['id']) {
            $error = "👑 Только глава ордена может проводить улучшения!";
        } elseif ($clan['silver'] < $cost) {
            $error = "🥈 В казне недостаточно серебра! Нужно: " . number_format($cost);
        } else {
            // Списываем из казны и повышаем уровень
            $db->prepare("UPDATE `clans` SET `silver` = `silver` - ?, `{$type}` = `{$type}` + 1 WHERE `id` = ?")
               ->execute([$cost, $clan['id']]);
            
            $message = "🏛 Улучшение завершено! Уровень повышен.";
            // Обновляем данные для отображения
            $clan['silver'] -= $cost;
            $clan[$type]++;
        }
    }
}

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .upg-wrapper { padding: 12px; max-width: 500px; margin: 0 auto; font-family: sans-serif; }
    .upg-card { background: #1a1a1a; border: 1px solid #333; border-radius: 16px; padding: 15px; margin-bottom: 15px; display: flex; align-items: center; justify-content: space-between; }
    .upg-info h4 { margin: 0; color: #fff; font-size: 1.1rem; }
    .upg-info p { margin: 5px 0; font-size: 0.8rem; color: #888; }
    .upg-lvl { color: #f1c40f; font-weight: bold; font-size: 0.9rem; }
    
    .btn-upg { background: #27ae60; color: #fff; border: none; padding: 10px 15px; border-radius: 8px; font-weight: bold; cursor: pointer; font-size: 0.8rem; }
    .btn-upg:disabled { background: #444; color: #777; cursor: not-allowed; }
    
    .treasury-info { background: #222; padding: 15px; border-radius: 12px; text-align: center; margin-bottom: 20px; border: 1px solid #444; }
    .back-block { margin-top: 20px; }
    .back-link { background: #2a2a2a; padding: 12px; border-radius: 10px; color: #aaa; text-decoration: none; display: block; text-align: center; border: 1px solid #333; }
    
    .alert { padding: 12px; border-radius: 10px; margin-bottom: 15px; text-align: center; font-size: 0.9rem; }
    .alert-err { background: rgba(231, 76, 60, 0.1); color: #ff7675; border: 1px solid rgba(231, 76, 60, 0.3); }
    .alert-ok { background: rgba(46, 204, 113, 0.1); color: #55efc4; border: 1px solid rgba(46, 204, 113, 0.3); }
</style>

<div class="upg-wrapper">
    <div class="treasury-info">
        <div style="font-size: 0.8rem; color: #888; text-transform: uppercase;">Казна Ордена</div>
        <div style="font-size: 1.4rem; color: #fff; font-weight: bold;"><?= number_format((int)$clan['silver']) ?> 🥈</div>
    </div>

    <?php if ($error): ?><div class="alert alert-err"><?= $error ?></div><?php endif; ?>
    <?php if ($message): ?><div class="alert alert-ok"><?= $message ?></div><?php endif; ?>

    <!-- Улучшение 1: Урон -->
    <div class="upg-card">
        <div class="upg-info">
            <h4>⚔ Зал Воителей</h4>
            <p>Бонус к урону всех участников: <b>+<?= $clan['upg_damage'] * 2 ?>%</b></p>
            <span class="upg-lvl">Уровень: <?= $clan['upg_damage'] ?></span>
        </div>
        <form method="POST">
            <input type="hidden" name="type" value="upg_damage">
            <?php $cost = ($clan['upg_damage'] + 1) * $base_cost; ?>
            <button type="submit" name="upgrade" class="btn-upg" <?= ($clan['silver'] < $cost) ? 'disabled' : '' ?>>
                Улучшить<br><small><?= number_format($cost) ?> 🥈</small>
            </button>
        </form>
    </div>

    <!-- Улучшение 2: Опыт -->
    <div class="upg-card">
        <div class="upg-info">
            <h4>📖 Храм Мудрости</h4>
            <p>Бонус к опыту в боях: <b>+<?= $clan['upg_exp'] * 3 ?>%</b></p>
            <span class="upg-lvl">Уровень: <?= $clan['upg_exp'] ?></span>
        </div>
        <form method="POST">
            <input type="hidden" name="type" value="upg_exp">
            <?php $cost = ($clan['upg_exp'] + 1) * $base_cost; ?>
            <button type="submit" name="upgrade" class="btn-upg" <?= ($clan['silver'] < $cost) ? 'disabled' : '' ?>>
                Улучшить<br><small><?= number_format($cost) ?> 🥈</small>
            </button>
        </form>
    </div>

    <div class="back-block">
        <a href="index.php" class="back-link">← Вернуться в цитадель</a>
    </div>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
