<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

// Если пользователь не залогинен, отправляем на главную
if (!$user) {
    header("Location: /index.php");
    exit;
}

// Если в URL есть action=yes, производим логаут
if (isset($_GET['action']) && $_GET['action'] === 'yes') {
    // Очищаем сессию (зависит от вашей системы core.php, обычно так:)
    session_destroy();
    setcookie('password', '', time() - 3600, '/');
    setcookie('login', '', time() - 3600, '/');
    
    header("Location: /index.php");
    exit;
}

require_once __DIR__ . '/system/head.php';
?>

<div style="padding: 20px; text-align: center; min-height: 80vh; display: flex; flex-direction: column; justify-content: center;">
    <div style="background: var(--panel); padding: 30px; border-radius: 25px; border: 1px solid rgba(255, 65, 108, 0.3);">
        <div style="font-size: 3rem; margin-bottom: 20px;">🚪</div>
        <h2 style="margin-bottom: 10px; color: #fff;">Покинуть игру?</h2>
        <p style="color: #8b949e; font-size: 0.9rem; margin-bottom: 30px;">Вы уверены, что хотите завершить текущую сессию?</p>
        
        <div style="display: flex; flex-direction: column; gap: 10px;">
            <!-- Кнопка подтверждения -->
            <a href="/exit.php?action=yes" style="background: #ff416c; color: #fff; padding: 15px; border-radius: 15px; text-decoration: none; font-weight: 800; text-transform: uppercase; font-size: 0.8rem;">
                Да, выйти
            </a>
            
            <!-- Кнопка отмены -->
            <a href="/id<?= $user['id'] ?>" style="background: rgba(255,255,255,0.05); color: #8b949e; padding: 15px; border-radius: 15px; text-decoration: none; font-weight: 800; text-transform: uppercase; font-size: 0.8rem;">
                Отмена
            </a>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
