<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) {
    header("Location: /index.php");
    exit;
}

$loc_id = (int)$user['loc'];
$stmt = $db->prepare("SELECT * FROM locations WHERE id = ?");
$stmt->execute([$loc_id]);
$current_loc = $stmt->fetch();

// Проверка: есть ли в локации ресурсы
if (!$current_loc || empty($current_loc['resource_node'])) {
    header("Location: location.php");
    exit;
}

// Защита от "закликивания" (кулдаун 5 секунд)
$last_gather = $_SESSION['last_gather'] ?? 0;
if (time() - $last_gather < 5) {
    header("Location: location.php?error=wait");
    exit;
}

$_SESSION['last_gather'] = time();

// Логика определения ID предмета на основе локации
// Предположим: локация 1 дает предмет ID 1 (Трава), локация 2 дает предмет ID 2 (Руда)
$item_id = ($loc_id == 1) ? 1 : 2; 
$amount = rand(1, 3);

// Шанс успеха 80%
if (rand(1, 100) <= 80) {
    // Вставляем или обновляем количество в едином инвентаре
    $stmt = $db->prepare("
        INSERT INTO `user_inventory` (`user_id`, `item_id`, `amount`) 
        VALUES (?, ?, ?) 
        ON DUPLICATE KEY UPDATE `amount` = `amount` + ?
    ");
    $stmt->execute([$user['id'], $item_id, $amount, $amount]);

    header("Location: location.php?success_gather=$amount");
} else {
    header("Location: location.php?error_gather=1");
}
exit;
