<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

$player_id = isset($_GET['id']) ? (int)$_GET['id'] : $user['id'];
$error = null;
$success = null;

// КАТАЛОГ ПОДАРКОВ 2026
$gift_catalog = [
    'common' => [
        'title' => 'Обычные (Серебро)',
        'currency' => 'silver',
        'items' => [
            ['icon' => '🍷', 'cost' => 50, 'name' => 'Вино'],
            ['icon' => '🍺', 'cost' => 30, 'name' => 'Эль'],
            ['icon' => '🥖', 'cost' => 10, 'name' => 'Хлеб'],
            ['icon' => '🌹', 'cost' => 100, 'name' => 'Роза'],
        ]
    ],
    'vip' => [
        'title' => 'VIP (Золото)',
        'currency' => 'gold',
        'items' => [
            ['icon' => '💎', 'cost' => 5, 'name' => 'Алмаз'],
            ['icon' => '⚔️', 'cost' => 10, 'name' => 'Меч'],
            ['icon' => '👑', 'cost' => 50, 'name' => 'Корона'],
            ['icon' => '🦄', 'cost' => 100, 'name' => 'Единорог'],
        ]
    ]
];

// --- ЛОГИКА ОТПРАВКИ ---
if (isset($_POST['send_gift']) && $player_id !== $user['id']) {
    $selected_category = $_POST['category'] ?? '';
    $selected_index = (int)($_POST['gift_index'] ?? 0);
    $msg = mb_substr(trim($_POST['message'] ?? ''), 0, 100);

    if (isset($gift_catalog[$selected_category]['items'][$selected_index])) {
        $gift = $gift_catalog[$selected_category]['items'][$selected_index];
        $curr = $gift_catalog[$selected_category]['currency'];
        $price = $gift['cost'];

        if ($user[$curr] < $price) {
            $error = "Недостаточно средств (" . ($curr == 'gold' ? '💰' : '🥈') . " $price)";
        } else {
            $db->prepare("INSERT INTO `gifts` (`sender_id`, `receiver_id`, `gift_type`, `message`, `created_at`) VALUES (?, ?, ?, ?, ?)")
               ->execute([$user['id'], $player_id, $gift['icon'], $msg, time()]);
            
            $db->prepare("UPDATE `users` SET `$curr` = `$curr` - ? WHERE `id` = ?")
               ->execute([$price, $user['id']]);
            
            $user[$curr] -= $price; // Обновляем баланс в сессии
            $success = "Подарок {$gift['icon']} отправлен!";
        }
    }
}

// Получаем список полученных
$stmt = $db->prepare("SELECT g.*, u.login as sender_name FROM `gifts` g JOIN `users` u ON g.sender_id = u.id WHERE g.receiver_id = ? ORDER BY g.created_at DESC");
$stmt->execute([$player_id]);
$gifts = $stmt->fetchAll();

require_once __DIR__ . '/system/head.php';
?>

<style>
    .g-container { background: var(--bg); min-height: 100vh; padding: 15px; font-family: 'Inter', sans-serif; }
    .cat-title { font-size: 0.75rem; color: #586069; text-transform: uppercase; font-weight: 800; margin: 20px 0 10px 5px; letter-spacing: 1px; }
    
    /* Сетка выбора */
    .gift-selector { display: grid; grid-template-columns: repeat(4, 1fr); gap: 10px; margin-bottom: 20px; }
    .gift-option { 
        background: var(--panel); border: 1px solid rgba(255,255,255,0.05); border-radius: 15px; 
        padding: 10px 5px; text-align: center; cursor: pointer; position: relative; 
    }
    .gift-option input { display: none; }
    .gift-option:has(input:checked) { border-color: var(--accent); background: rgba(0,212,255,0.05); }
    .g-icon { font-size: 1.5rem; display: block; }
    .g-cost { font-size: 0.65rem; font-weight: 700; margin-top: 5px; }

    .gifts-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px; }
    .gift-received { background: var(--panel); border-radius: 12px; padding: 10px; text-align: center; border: 1px solid rgba(255,255,255,0.03); }
    .g-sender-name { font-size: 0.55rem; color: #586069; text-transform: uppercase; margin-top: 4px; display: block; overflow: hidden; }

    .btn-send { width: 100%; padding: 18px; border-radius: 18px; border: none; background: var(--accent); color: #000; font-weight: 800; margin-top: 15px; }
    .alert { padding: 15px; border-radius: 15px; margin-bottom: 15px; text-align: center; font-weight: 700; font-size: 0.85rem; }
</style>

<div class="g-container">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <a href="/profile.php?id=<?= $player_id ?>" style="color: #586069; text-decoration: none; font-size: 0.8rem; font-weight: 800;">← ПРОФИЛЬ</a>
        <span style="font-weight: 900; color: var(--accent);">АРХИВ (<?= count($gifts) ?>)</span>
    </div>

    <?php if ($error): ?> <div class="alert" style="background: rgba(255,65,108,0.1); color: #ff416c;"><?= $error ?></div> <?php endif; ?>
    <?php if ($success): ?> <div class="alert" style="background: rgba(46,204,113,0.1); color: #2ecc71;"><?= $success ?></div> <?php endif; ?>

    <!-- Список полученных -->
    <div class="gifts-grid">
        <?php foreach ($gifts as $g): ?>
            <div class="gift-received" title="<?= htmlspecialchars($g['message']) ?>">
                <span style="font-size: 1.5rem;"><?= $g['gift_type'] ?></span>
                <span class="g-sender-name"><?= htmlspecialchars($g['sender_name']) ?></span>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Форма выбора подарка -->
    <?php if ($player_id !== $user['id']): ?>
    <form method="POST" style="margin-top: 30px;">
        <?php foreach ($gift_catalog as $cat_key => $cat): ?>
            <div class="cat-title"><?= $cat['title'] ?></div>
            <div class="gift-selector">
                <?php foreach ($cat['items'] as $index => $item): ?>
                    <label class="gift-option">
                        <input type="radio" name="gift_info" value="<?= $cat_key ?>:<?= $index ?>" 
                               onclick="document.getElementById('cat_in').value='<?= $cat_key ?>'; document.getElementById('idx_in').value='<?= $index ?>'">
                        <span class="g-icon"><?= $item['icon'] ?></span>
                        <div class="g-cost" style="color: <?= $cat['currency'] == 'gold' ? '#ffcc00' : '#ced4da' ?>">
                            <?= $cat['currency'] == 'gold' ? '💰' : '🥈' ?> <?= $item['cost'] ?>
                        </div>
                    </label>
                <?php endforeach; ?>
            </div>
        <?php endforeach; ?>

        <input type="hidden" name="category" id="cat_in" value="common">
        <input type="hidden" name="gift_index" id="idx_in" value="0">
        
        <input type="text" name="message" class="g-input" placeholder="Ваше послание..." 
               style="width: 100%; background: var(--panel); border: 1px solid rgba(255,255,255,0.1); padding: 15px; border-radius: 15px; color: #fff; box-sizing: border-box;">
        
        <button type="submit" name="send_gift" class="btn-send">ОТПРАВИТЬ ПОДАРОК</button>
    </form>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
