<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

// Если игрок уже авторизован — отправляем в игру
if (isset($user) && $user) {
    header("Location: /main.php");
    exit;
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    /* Базовый контейнер */
    .landing-page {
        min-height: 100vh;
        background: #0f111a;
        padding: 20px;
        display: flex;
        flex-direction: column;
        gap: 15px; 
        font-family: 'Inter', sans-serif;
    }

    /* Блок 1: Заголовок игры */
    .hero-block {
        text-align: center;
        padding: 10px 0;
    }
    .game-title {
        font-size: 2.4rem;
        font-weight: 900;
        color: #fff;
        margin: 0;
        letter-spacing: -1px;
        text-transform: uppercase;
        background: linear-gradient(to bottom, #fff, #8b949e);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }
    .game-tagline {
        color: var(--accent, #2ecc71);
        font-size: 0.75rem;
        font-weight: 800;
        letter-spacing: 4px;
        text-transform: uppercase;
        margin-top: 5px;
    }

    /* Блок 2: Форма входа */
    .auth-block {
        background: var(--panel, #1c2128);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 25px;
        padding: 25px 20px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.4);
    }
    .input-field {
        width: 100%;
        background: #0d1117;
        border: 1px solid rgba(255, 255, 255, 0.1);
        padding: 15px;
        border-radius: 15px;
        color: #fff;
        font-size: 1rem;
        margin-bottom: 15px; /* Отступ от логина к паролю */
        box-sizing: border-box;
        text-align: center;
        transition: 0.3s;
    }
    .input-field:focus {
        border-color: var(--accent, #2ecc71);
        outline: none;
    }
    .btn-login {
        width: 100%;
        padding: 15px;
        border-radius: 15px;
        border: none;
        background: #fff;
        color: #000;
        font-weight: 800;
        font-size: 0.9rem;
        text-transform: uppercase;
        cursor: pointer;
        margin-top: 10px; /* Отступ от пароля к кнопке */
    }

    /* Блок 3: Регистрация */
    .reg-block {
        background: rgba(255, 255, 255, 0.02);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 15px;
        padding: 20px;
        text-align: center;
        margin-top: 15px; /* Отступ от формы входа к ссылке регистрации */
    }
    .reg-link {
        color: var(--accent, #2ecc71);
        text-decoration: none;
        font-weight: 700;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    /* Блок 4: Навигация подвала */
    .footer-nav {
        display: flex;
        justify-content: center;
        gap: 12px;
        padding: 5px 0;
    }
    .f-link {
        color: #5b646e;
        text-decoration: none;
        font-size: 0.65rem;
        text-transform: uppercase;
        font-weight: 700;
        letter-spacing: 1px;
    }

    /* Блок 5: Статистика онлайна */
    .stats-block {
        text-align: center;
        margin-top: 5px;
    }
    .online-indicator {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        background: rgba(46, 204, 113, 0.03);
        padding: 6px 12px;
        border-radius: 10px;
        font-size: 0.65rem;
        color: #2ecc71;
        font-weight: 800;
        border: 1px solid rgba(46, 204, 113, 0.08);
    }
    .dot {
        width: 5px;
        height: 5px;
        background: #2ecc71;
        border-radius: 50%;
        box-shadow: 0 0 8px #2ecc71;
    }
</style>

<div class="landing-page">
    
    <div class="hero-block">
        <h1 class="game-title">ВОЙНА БОГОВ</h1>
        <div class="game-tagline">MMORPG 2026</div>
    </div>

    <div class="auth-block">
        <form action="/login.php" method="POST">
            <input type="text" name="login" class="input-field" placeholder="ИМЯ ГЕРОЯ" required>
            <input type="password" name="password" class="input-field" placeholder="ПАРОЛЬ" required>
            <button type="submit" class="btn-login">ПРОДОЛЖИТЬ ПУТЬ</button>
        </form>
    </div>

    <div class="reg-block">
        <a href="/reg.php" class="reg-link">Создать нового героя →</a>
    </div>

    <div class="footer-nav">
        <a href="/about.php" class="f-link">Об игре</a>
        <a href="/rules.php" class="f-link">Правила</a>
        <a href="/support.php" class="f-link">Поддержка</a>
    </div>

    <div class="stats-block">
        <div class="online-indicator">
            <span class="dot"></span>
            ОНЛАЙН : <?php 
                try {
                    echo (int)$db->query("SELECT COUNT(*) FROM users WHERE last_visit > ".(time()-300))->fetchColumn();
                } catch(Exception $e) {
                    echo 0;
                }
            ?>
        </div>
    </div>

</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
