<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

// Если игрок уже авторизован — отправляем в игру
if ($user) {
    header("Location: /main.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = trim($_POST['login'] ?? '');
    $pass = $_POST['password'] ?? '';

    if (!empty($login) && !empty($pass)) {
        // Ищем героя в базе
        $stmt = $db->prepare("SELECT * FROM `users` WHERE `login` = ? LIMIT 1");
        $stmt->execute([$login]);
        $userData = $stmt->fetch();

        // Проверяем пароль (совместимо с нашей регистрацией через password_hash)
        if ($userData && password_verify($pass, $userData['password'])) {
            $_SESSION['user_id'] = (int)$userData['id'];
            header("Location: /main.php");
            exit;
        } else {
            $error = "ИМЯ ИЛИ ПАРОЛЬ НЕ ВЕРНЫ";
        }
    } else {
        $error = "ЗАПОЛНИТЕ ВСЕ ПОЛЯ";
    }
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    .auth-page {
        min-height: 100vh;
        background: #0f111a;
        padding: 40px 20px;
        display: flex;
        flex-direction: column;
        gap: 20px;
        font-family: 'Inter', sans-serif;
    }

    .auth-block {
        background: var(--panel, #1c2128);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 30px;
        padding: 30px 20px;
        box-shadow: 0 15px 35px rgba(0,0,0,0.4);
    }

    .title-small {
        color: #fff;
        text-align: center;
        font-weight: 900;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-bottom: 25px;
    }

    .input-field {
        width: 100%;
        background: #0d1117;
        border: 1px solid rgba(255, 255, 255, 0.1);
        padding: 18px;
        border-radius: 18px;
        color: #fff;
        font-size: 1rem;
        margin-bottom: 15px;
        box-sizing: border-box;
        text-align: center;
        transition: 0.3s;
    }

    .input-field:focus {
        border-color: var(--accent, #2ecc71);
        outline: none;
    }

    .btn-auth {
        width: 100%;
        padding: 18px;
        border-radius: 18px;
        border: none;
        background: #fff;
        color: #000;
        font-weight: 800;
        text-transform: uppercase;
        cursor: pointer;
        transition: 0.2s;
    }

    .btn-auth:active {
        transform: scale(0.97);
    }

    .error-box {
        background: rgba(231, 76, 60, 0.1);
        color: #e74c3c;
        padding: 15px;
        border-radius: 15px;
        text-align: center;
        font-size: 0.8rem;
        font-weight: 700;
        border: 1px solid rgba(231, 76, 60, 0.2);
        margin-bottom: 15px;
    }

    .footer-link {
        text-align: center;
        margin-top: 10px;
    }

    .link-text {
        color: #8b949e;
        text-decoration: none;
        font-size: 0.8rem;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .accent-text {
        color: var(--accent, #2ecc71);
        font-weight: 700;
    }
</style>

<div class="auth-page">

    <!-- Блок входа -->
    <div class="auth-block">
        <div class="title-small">Вернуться в мир</div>

        <?php if ($error): ?>
            <div class="error-box"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">
            <input type="text" name="login" class="input-field" placeholder="ИМЯ ГЕРОЯ" required>
            <input type="password" name="password" class="input-field" placeholder="ПАРОЛЬ" required>
            
            <button type="submit" class="btn-auth">ПРОДОЛЖИТЬ ПУТЬ</button>
        </form>
    </div>

    <!-- Блок навигации -->
    <div class="footer-link">
        <a href="/reg.php" class="link-text">Нет героя? <span class="accent-text">Создать →</span></a>
    </div>
    
    <div class="footer-link">
        <a href="/" class="link-text">← На главную</a>
    </div>

</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
