<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) {
    header("Location: /index.php");
    exit;
}

// --- ЛОГИКА СЧЕТЧИКОВ ---
$time24 = time() - 86400;
$chat_count = (int)$db->query("SELECT COUNT(*) FROM `chat_messages` WHERE `created_at` > $time24")->fetchColumn();
$online_count = (int)$db->query("SELECT COUNT(*) FROM `users` WHERE `last_visit` > ".(time()-1800))->fetchColumn();
$news_count = (int)$db->query("SELECT COUNT(*) FROM `news` WHERE `created_at` > $time24")->fetchColumn(); 

require_once __DIR__ . '/system/head.php';
?>

<style>
    :root {
        --panel: #161b22;
        --border: rgba(255, 255, 255, 0.08);
        --accent: #00d4ff;
        --gold: #ffcc00;
        --danger: #ff416c;
        --success: #2ecc71; 
        --bg-grad: linear-gradient(145deg, #1c2128, #111418);
    }

    .game-wrapper { padding: 8px; animation: fadeIn 0.5s ease-in; max-width: 500px; margin: 0 auto; }
    @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }

    .loc-card { background: var(--bg-grad); border: 1px solid var(--border); border-radius: 12px; padding: 12px; display: flex; align-items: center; gap: 12px; margin-bottom: 12px; }
    .loc-icon { font-size: 1.8rem; }
    .loc-name { font-weight: 700; color: #fff; font-size: 0.95rem; }
    .loc-status { font-size: 0.65rem; color: #00ff88; text-transform: uppercase; font-weight: bold; }

    .main-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; margin-bottom: 20px; }
    
    .grid-item { 
        background: var(--panel); 
        border: 1px solid var(--border); 
        border-radius: 14px; 
        text-decoration: none; 
        display: flex; 
        flex-direction: column; 
        align-items: center; 
        justify-content: center; 
        transition: all 0.2s ease; 
        padding: 20px 10px; 
        position: relative; 
    }
    
    .grid-item:active { transform: scale(0.96); background: #1c2128; }
    
    .g-icon { font-size: 1.8rem; margin-bottom: 8px; }
    .g-label { 
        font-size: 0.75rem; 
        font-weight: 800; 
        text-transform: uppercase; 
        color: rgba(255,255,255,0.8); 
        letter-spacing: 0.5px;
    }

    .badge { position: absolute; top: 10px; right: 10px; color: #000; font-size: 0.65rem; font-weight: 900; padding: 2px 6px; border-radius: 7px; }
    .bg-blue { background: var(--accent); box-shadow: 0 0 10px var(--accent); }
    .bg-green { background: var(--success); box-shadow: 0 0 10px var(--success); }
    .bg-gold { background: var(--gold); box-shadow: 0 0 10px var(--gold); }

    /* Блок Админ-панели */
    .admin-block { 
        background: rgba(255, 65, 108, 0.03); 
        border: 1px dashed rgba(255, 65, 108, 0.4); 
        border-radius: 16px; 
        padding: 15px; 
        margin-top: 10px;
    }
    .admin-title { 
        color: var(--danger); 
        font-size: 0.65rem; 
        font-weight: 900; 
        text-transform: uppercase; 
        margin-bottom: 12px; 
        display: flex; 
        align-items: center; 
        gap: 6px; 
        justify-content: center;
    }
    .admin-btn { 
        display: block; 
        background: var(--danger); 
        color: #fff; 
        text-align: center; 
        text-decoration: none; 
        padding: 12px; 
        border-radius: 10px; 
        font-weight: 800; 
        font-size: 0.8rem; 
        text-transform: uppercase;
        transition: opacity 0.2s;
    }
    .admin-btn:active { opacity: 0.8; }
</style>

<div class="game-wrapper">
    <div class="loc-card">
        <div class="loc-icon">⛩️</div>
        <div class="loc-info">
            <div class="loc-name">Центральная Площадь</div>
            <div class="loc-status">● 2026: Мирная зона</div>
        </div>
    </div>

    <div class="main-grid">
        <a href="/news.php" class="grid-item">
            <?php if ($news_count > 0): ?><span class="badge bg-gold"><?= $news_count ?></span><?php endif; ?>
            <span class="g-icon">📜</span><span class="g-label">Новости</span>
        </a>

        <a href="/chat.php" class="grid-item">
            <?php if ($chat_count > 0): ?><span class="badge bg-blue"><?= $chat_count ?></span><?php endif; ?>
            <span class="g-icon">💬</span><span class="g-label">Чат</span>
        </a>

        <a href="/online.php" class="grid-item">
            <span class="badge bg-green"><?= $online_count ?></span>
            <span class="g-icon">👥</span><span class="g-label">В сети</span>
        </a>

        <a href="/battle.php" class="grid-item">
            <span class="g-icon">⚔️</span><span class="g-label">Арена</span>
        </a>

        <a href="/market.php" class="grid-item">
            <span class="g-icon">⚖️</span><span class="g-label">Маркет</span>
        </a>

        <a href="/top.php" class="grid-item">
            <span class="g-icon">🏆</span><span class="g-label">Топ</span>
        </a>
    </div>

    <!-- Админ-панель -->
    <?php if (isset($user['access']) && (int)$user['access'] >= 2): ?>
        <div class="admin-block">
            <div class="admin-title">
                <span>🛡️</span> Система управления
            </div>
            <a href="/admin/" class="admin-btn">
                Открыть Админ-панель
            </a>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
