<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .shop-grid-container { padding: 12px; max-width: 500px; margin: 0 auto; }
    
    /* Описание магазина */
    .market-intro { 
        background: linear-gradient(145deg, #1c2128, #111418); 
        border: 1px solid #30363d; 
        border-radius: 20px; 
        padding: 25px 20px; 
        text-align: center;
        margin-bottom: 20px;
    }
    
    .market-title {
        color: #fff; 
        font-size: 1.5rem; 
        font-weight: 900; 
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-bottom: 12px;
        display: block;
    }

    .market-text {
        color: #8b949e;
        font-size: 0.9rem;
        line-height: 1.6;
        font-style: italic;
    }

    /* Список разделов */
    .shop-nav { display: flex; flex-direction: column; gap: 12px; }
    
    .shop-link { 
        background: #161b22; 
        border: 1px solid #30363d; 
        border-radius: 16px; 
        padding: 20px; 
        text-decoration: none; 
        display: flex; 
        align-items: center; 
        transition: all 0.2s ease; 
    }
    
    .shop-link:active { transform: scale(0.97); background: #1c2128; }
    
    .shop-icon-circle { 
        width: 54px; height: 54px; 
        background: #0d1117; 
        border-radius: 14px; 
        display: flex; 
        align-items: center; 
        justify-content: center; 
        font-size: 2rem; 
        margin-right: 15px; 
        border: 1px solid rgba(255,255,255,0.05);
    }
    
    .shop-info-text { flex-grow: 1; }
    .shop-name { display: block; color: #fff; font-weight: bold; font-size: 1.15rem; }
    .shop-description { display: block; color: #8b949e; font-size: 0.85rem; margin-top: 4px; }
    
    .arrow-next { color: #30363d; font-size: 1.2rem; }

    .accent-rare { border-left: 5px solid #a855f7; }
    .accent-amulet { border-left: 5px solid #ff416c; }
</style>

<div class="shop-grid-container">
    <!-- Описание магазина -->
    <div class="market-intro">
        <span class="market-title">Городской Рынок</span>
        <p class="market-text">
            Среди шумных рядов и пестрых шатров вы найдете то, что не купишь у обычных кузнецов. Редчайшие артефакты и древние обереги ждут своих владельцев.
        </p>
    </div>

    <div class="shop-nav">
        <!-- 1. Лавка редкостей -->
        <a href="rare.php" class="shop-link accent-rare">
            <div class="shop-icon-circle">💎</div>
            <div class="shop-info-text">
                <span class="shop-name">Лавка редкостей</span>
                <span class="shop-description">Ценные артефакты и мистический обмен</span>
            </div>
            <span class="arrow-next">➜</span>
        </a>

        <!-- 2. Амулеты -->
        <a href="amulets.php" class="shop-link accent-amulet">
            <div class="shop-icon-circle">🧿</div>
            <div class="shop-info-text">
                <span class="shop-name">Амулеты</span>
                <span class="shop-description">Древние обереги для Арены и Подземелий</span>
            </div>
            <span class="arrow-next">➜</span>
        </a>
    </div>
</div>

<?php 
require_once __DIR__ . '/../system/foot.php'; 
?>
