<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';
if (!$user) { header("Location: /index.php"); exit; }
require_once __DIR__ . '/../system/head.php';

$stmt = $db->query("SELECT * FROM `news` ORDER BY `created_at` DESC LIMIT 20");
$news_list = $stmt->fetchAll();

function getCatStyles($cat) {
    return match($cat) {
        'Обновление' => ['bg' => 'rgba(46, 204, 113, 0.1)', 'color' => '#2ecc71'],
        'Тех.работы' => ['bg' => 'rgba(241, 196, 15, 0.1)', 'color' => '#f1c40f'],
        'Важное'     => ['bg' => 'rgba(231, 76, 60, 0.1)', 'color' => '#e74c3c'],
        default      => ['bg' => 'rgba(52, 152, 219, 0.1)', 'color' => '#3498db'],
    };
}
?>

<style>
    .news-container { padding: 10px; max-width: 600px; margin: 0 auto; padding-bottom: 80px; }
    .news-card { background: #1c2128; border: 1px solid rgba(255,255,255,0.08); border-radius: 12px; margin-bottom: 15px; padding: 15px; }
    .news-header { display: flex; justify-content: space-between; margin-bottom: 10px; }
    .cat-badge { font-size: 0.6rem; padding: 3px 8px; border-radius: 6px; font-weight: 800; border: 1px solid; text-transform: uppercase; }
    .news-title { font-size: 1.1rem; color: #fff; font-weight: bold; margin-bottom: 8px; display: block; }
    .news-text { color: #abb2bf; font-size: 0.9rem; line-height: 1.5; }
    
    /* Стили для лайков */
    .news-actions { display: flex; gap: 15px; margin-top: 15px; padding-top: 10px; border-top: 1px solid rgba(255,255,255,0.05); }
    .vote-btn { text-decoration: none; font-size: 0.8rem; display: flex; align-items: center; gap: 5px; transition: 0.2s; padding: 5px 10px; border-radius: 8px; background: rgba(255,255,255,0.03); }
    .btn-like { color: #2ecc71; }
    .btn-dislike { color: #e74c3c; }
    .vote-btn:active { transform: scale(0.9); background: rgba(255,255,255,0.1); }
</style>

<div class="news-container">
    <h2 style="color:#fff; margin-bottom: 15px;">Вестник Хаты</h2>

    <?php foreach ($news_list as $n): 
        $style = getCatStyles($n['category']);
    ?>
        <div class="news-card">
            <div class="news-header">
                <span class="cat-badge" style="background: <?= $style['bg'] ?>; color: <?= $style['color'] ?>; border-color: <?= $style['color'] ?>;">
                    <?= htmlspecialchars($n['category']) ?>
                </span>
                <span style="font-size:0.7rem; color:gray;"><?= date("d.m.y", (int)$n['created_at']) ?></span>
            </div>
            
            <span class="news-title"><?= htmlspecialchars($n['title']) ?></span>
            <div class="news-text"><?= nl2br(htmlspecialchars($n['text'])) ?></div>

            <div class="news-actions">
                <a href="vote.php?id=<?= $n['id'] ?>&type=like" class="vote-btn btn-like">
                    👍 <span><?= $n['likes'] ?></span>
                </a>
                <a href="vote.php?id=<?= $n['id'] ?>&type=dislike" class="vote-btn btn-dislike">
                    👎 <span><?= $n['dislikes'] ?></span>
                </a>
                <span style="margin-left: auto; color:gray; font-size:0.7rem;">Автор: <?= htmlspecialchars($n['author']) ?></span>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
