<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || !isset($_GET['id'], $_GET['type'])) {
    header("Location: index.php");
    exit;
}

$newsId = (int)$_GET['id'];
$type = $_GET['type'] === 'like' ? 'like' : 'dislike';
$userId = (int)$user['id'];

// Проверяем, голосовал ли уже
$check = $db->prepare("SELECT id, type FROM `news_likes` WHERE `news_id` = ? AND `user_id` = ?");
$check->execute([$newsId, $userId]);
$vote = $check->fetch();

if (!$vote) {
    // Новый голос
    $db->prepare("INSERT INTO `news_likes` (news_id, user_id, type) VALUES (?, ?, ?)")->execute([$newsId, $userId, $type]);
    $column = ($type === 'like') ? 'likes' : 'dislikes';
    $db->prepare("UPDATE `news` SET `$column` = `$column` + 1 WHERE `id` = ?")->execute([$newsId]);
} 

header("Location: index.php");
exit;
