<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

// Если это AJAX-запрос, отдаем только список игроков
if (isset($_GET['fetch'])) {
    header('Content-Type: text/html; charset=utf-8');
    $online_time = time() - 1800;
    $stmt = $db->prepare("SELECT * FROM users WHERE last_visit > ? ORDER BY level DESC");
    $stmt->execute([$online_time]);
    $players = $stmt->fetchAll();

    if (empty($players)): ?>
        <div class="empty-list">Никто не играет прямо сейчас...</div>
    <?php else: ?>
        <?php foreach ($players as $p): ?>
            <div class="player-card">
                <div class="player-info">
                    <!-- Ссылка на профиль игрока (предполагаем, что будет файл profile.php?id=...) -->
                    <a href="/profile.php?id=<?= $p['id'] ?>" class="player-name-link">
                        <?= htmlspecialchars($p['login']) ?> [<?= $p['level'] ?> Ур.]
                    </a>
                    <span class="player-stats">⚔️ Сила: <?= $p['str'] ?> | 🛡️ Защита: <?= $p['def'] ?></span>
                </div>
                <span class="status-online">ОНЛАЙН</span>
            </div>
        <?php endforeach; ?>
    <?php endif;
    exit;
}

// Если это обычный запрос через браузер, показываем всю страницу:

if (!$user) {
    header("Location: /login.php");
    exit;
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    /* Обновленные стили для более четкого и "металлического" вида */
    .online-list-page { min-height: 100vh; background: #0f111a; padding: 20px; font-family: 'Inter', sans-serif; display: flex; flex-direction: column; gap: 10px; }
    .title { color: #fff; font-weight: 900; text-transform: uppercase; text-align: center; font-size: 1.2rem; margin-bottom: 10px; }
    
    .player-card {
        background: #1a1e24; /* Более темный фон карточки */
        border: 1px solid #3d4a5c; /* Четкая граница */
        border-radius: 8px; /* Менее скругленные углы */
        padding: 12px 15px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 8px;
    }
    .player-name-link {
        color: #fff; /* Белый цвет для имени */
        font-weight: 800;
        font-size: 0.9rem;
        text-decoration: none; /* Убираем подчеркивание */
        text-transform: uppercase;
        transition: color 0.2s;
    }
    .player-name-link:hover {
        color: var(--accent, #2ecc71); /* Зеленый при наведении */
    }
    .player-stats {
        color: #7b8a9e; /* Серый для характеристик */
        font-size: 0.7rem;
        margin-top: 4px;
        display: block;
    }
    .status-online {
        color: #2ecc71; /* Ярко-зеленый */
        font-size: 0.7rem;
        font-weight: 800;
        letter-spacing: 1px;
    }
    .empty-list { text-align: center; color: #5b646e; padding: 40px; font-size: 0.8rem; }
    .loader { text-align: center; color: #5b646e; padding: 40px; font-size: 0.8rem; }
</style>

<div class="online-list-page">
    <div class="title">Боги в сети</div>

    <div id="online-list-container">
        <div class="loader">Загрузка списка...</div>
    </div>

    <a href="/main.php" style="text-align:center; color:#5b646e; text-decoration:none; font-size:0.75rem; text-transform:uppercase; margin-top:20px;">Вернуться назад</a>
</div>

<script>
    function loadOnlinePlayers() {
        fetch('/online.php?fetch=1')
            .then(response => response.text())
            .then(html => {
                document.getElementById('online-list-container').innerHTML = html;
            })
            .catch(error => {
                console.error('Ошибка загрузки списка:', error);
            });
    }

    loadOnlinePlayers();
    setInterval(loadOnlinePlayers, 15000);
</script>

<?php require_once __DIR__ . '/system/foot.php'; ?>
