<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

$msg = "";

// 1. Взять квест
if (isset($_GET['take'])) {
    $q_id = (int)$_GET['take'];
    $db->prepare("INSERT IGNORE INTO `user_quests` (user_id, quest_id, status) VALUES (?, ?, 'active')")
       ->execute([$user['id'], $q_id]);
    header("Location: quests.php?ok=taken"); exit;
}

// 2. Сдать квест
if (isset($_GET['finish'])) {
    $q_id = (int)$_GET['finish'];
    
    // Проверка выполнения
    $stmt = $db->prepare("SELECT uq.*, ql.* FROM user_quests uq JOIN quests_list ql ON uq.quest_id = ql.id WHERE uq.user_id = ? AND uq.quest_id = ? AND uq.status = 'active'");
    $stmt->execute([$user['id'], $q_id]);
    $q = $stmt->fetch();

    if ($q && $q['current_amount'] >= $q['target_amount']) {
        $db->beginTransaction();
        $db->prepare("UPDATE user_quests SET status = 'completed' WHERE user_id = ? AND quest_id = ?")->execute([$user['id'], $q_id]);
        $db->prepare("UPDATE users SET gold = gold + ?, exp = exp + ? WHERE id = ?")->execute([$q['reward_gold'], $q['reward_exp'], $user['id']]);
        $db->commit();
        header("Location: quests.php?ok=done"); exit;
    }
}

require_once __DIR__ . '/system/head.php';

// Получаем список активных и доступных квестов
$active_quests = $db->prepare("SELECT uq.*, ql.* FROM user_quests uq JOIN quests_list ql ON uq.quest_id = ql.id WHERE uq.user_id = ? AND uq.status = 'active'");
$active_quests->execute([$user['id']]);
$my_quests = $active_quests->fetchAll();

$available_quests = $db->prepare("SELECT * FROM quests_list WHERE id NOT IN (SELECT quest_id FROM user_quests WHERE user_id = ?) AND req_level <= ?");
$available_quests->execute([$user['id'], $user['level']]);
$new_quests = $available_quests->fetchAll();
?>

<style>
    .quest-card { background: #161b22; border: 1px solid #30363d; border-radius: 14px; padding: 15px; margin-bottom: 12px; }
    .q-title { color: var(--accent); font-weight: bold; font-size: 1rem; margin-bottom: 5px; display: block; }
    .q-desc { color: #8b949e; font-size: 0.8rem; line-height: 1.4; margin-bottom: 10px; }
    .q-progress { background: #0d1117; height: 8px; border-radius: 4px; overflow: hidden; margin: 8px 0; }
    .q-bar { height: 100%; background: var(--accent); transition: width 0.3s; }
    .q-reward { font-size: 0.75rem; color: var(--gold); font-weight: bold; }
    .btn-q { display: inline-block; padding: 8px 15px; border-radius: 8px; text-decoration: none; font-weight: bold; font-size: 0.8rem; margin-top: 10px; }
    .btn-take { background: #30363d; color: #fff; }
    .btn-finish { background: var(--success); color: #000; }
</style>

<div style="padding: 10px; max-width: 500px; margin: 0 auto;">
    <h3 style="color:#fff; margin-bottom:15px;">📜 Журнал заданий</h3>

    <!-- Активные квесты -->
    <?php foreach ($my_quests as $q): 
        $pct = min(100, ($q['current_amount'] / $q['target_amount']) * 100);
        $done = ($q['current_amount'] >= $q['target_amount']);
    ?>
        <div class="quest-card" style="border-left: 4px solid <?= $done ? 'var(--success)' : 'var(--accent)' ?>;">
            <span class="q-title"><?= htmlspecialchars($q['title']) ?></span>
            <div class="q-desc"><?= htmlspecialchars($q['description']) ?></div>
            <div style="font-size:0.75rem; color:#fff;">Прогресс: <?= $q['current_amount'] ?> / <?= $q['target_amount'] ?></div>
            <div class="q-progress"><div class="q-bar" style="width: <?= $pct ?>%;"></div></div>
            <div class="q-reward">Награда: <?= $q['reward_gold'] ?> 💰 | <?= $q['reward_exp'] ?> EXP</div>
            
            <?php if ($done): ?>
                <a href="?finish=<?= $q['quest_id'] ?>" class="btn-q btn-finish">ЗАВЕРШИТЬ</a>
            <?php else: ?>
                <div style="font-size:0.7rem; color:gray; margin-top:10px;">Выполняйте условия в локациях</div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>

    <!-- Новые квесты -->
    <?php if ($new_quests): ?>
        <h4 style="color:gray; margin: 20px 0 10px 0; font-size:0.8rem; text-transform:uppercase;">Доступные поручения</h4>
        <?php foreach ($new_quests as $q): ?>
            <div class="quest-card">
                <span class="q-title"><?= htmlspecialchars($q['title']) ?></span>
                <div class="q-desc"><?= htmlspecialchars($q['description']) ?></div>
                <div class="q-reward">Награда: <?= $q['reward_gold'] ?> 💰</div>
                <a href="?take=<?= $q['id'] ?>" class="btn-q btn-take">ВЗЯТЬ ЗАДАНИЕ</a>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <?php if (!$my_quests && !$new_quests): ?>
        <div style="text-align:center; color:gray; padding:50px;">Для вас пока нет новых заданий.</div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
