<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

// Если игрок уже авторизован
if (isset($user) && $user) {
    header("Location: /main.php");
    exit;
}

$error = '';
$success_data = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = trim($_POST['login'] ?? '');
    $pass = $_POST['password'] ?? '';
    $captcha_input = trim($_POST['captcha'] ?? '');

    // Получаем правильный ответ из сессии
    $session_captcha = isset($_SESSION['captcha']) ? (string)$_SESSION['captcha'] : '';

    if ($captcha_input === '' || $captcha_input !== $session_captcha) {
        $error = "ДУХИ НЕ УЗНАЛИ ТЕБЯ (ОШИБКА ВЫЧИСЛЕНИЯ)";
    } 
    elseif (mb_strlen($login) < 3 || mb_strlen($login) > 15) {
        $error = "ИМЯ ГЕРОЯ ДОЛЖНО БЫТЬ ОТ 3 ДО 15 СИМВОЛОВ";
    }
    elseif (mb_strlen($pass) < 6) {
        $error = "ПАРОЛЬ СЛИШКОМ СЛАБ (МИН. 6 СИМВ.)";
    } else {
        $stmt = $db->prepare("SELECT id FROM users WHERE login = ?");
        $stmt->execute([$login]);
        
        if ($stmt->fetch()) {
            $error = "ЭТО ИМЯ УЖЕ ЗАНЯТО";
        } else {
            $recovery_code = substr(str_shuffle("ABCDEFGHJKLMNPQRSTUVWXYZ23456789"), 0, 8);
            $hashed_pass = password_hash($pass, PASSWORD_DEFAULT);

            try {
                $sql = "INSERT INTO users (login, password, recovery_code, level, exp, exp_next, str, agi, def, hp_max, last_visit) 
                        VALUES (?, ?, ?, 1, 0, 100, 5, 5, 5, 100, ?)";
                $db->prepare($sql)->execute([$login, $hashed_pass, $recovery_code, time()]);
                
                $success_data = [
                    'login' => $login,
                    'code' => $recovery_code
                ];
                unset($_SESSION['captcha']);
            } catch (Exception $e) {
                $error = "ОШИБКА ХРАМА: " . $e->getMessage();
            }
        }
    }
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    .reg-page { min-height: 100vh; background: #0f111a; padding: 40px 20px; display: flex; flex-direction: column; gap: 20px; font-family: 'Inter', sans-serif; }
    .reg-block { background: #1c2128; border: 1px solid rgba(255, 255, 255, 0.05); border-radius: 30px; padding: 30px 20px; box-shadow: 0 15px 35px rgba(0,0,0,0.4); }
    .title-small { color: #fff; text-align: center; font-weight: 900; text-transform: uppercase; margin-bottom: 25px; }
    .input-field { width: 100%; background: #0d1117; border: 1px solid rgba(255, 255, 255, 0.1); padding: 18px; border-radius: 18px; color: #fff; font-size: 1rem; margin-bottom: 15px; box-sizing: border-box; text-align: center; }
    .btn-reg { width: 100%; padding: 18px; border-radius: 18px; border: none; background: #2ecc71; color: #000; font-weight: 800; text-transform: uppercase; cursor: pointer; display: block; text-decoration: none; text-align: center; }
    .error-box { background: rgba(231, 76, 60, 0.1); color: #e74c3c; padding: 15px; border-radius: 15px; text-align: center; font-size: 0.8rem; font-weight: 700; border: 1px solid rgba(231, 76, 60, 0.2); margin-bottom: 15px; }
    .success-card { text-align: center; }
    .recovery-alert { background: rgba(46, 204, 113, 0.05); border: 2px dashed #2ecc71; padding: 20px; border-radius: 20px; margin: 20px 0; }
    .code-display { font-size: 1.5rem; color: #fff; font-weight: 900; letter-spacing: 3px; margin: 10px 0; display: block; }
</style>

<div class="reg-page">
    <div class="reg-block">
        <?php if ($success_data): ?>
            <div class="success-card">
                <h2 style="color:#2ecc71; margin-top:0;">ГЕРОЙ РОЖДЕН!</h2>
                <p style="color:#8b949e; font-size:0.9rem;">Запиши свой секретный код для восстановления:</p>
                <div class="recovery-alert">
                    <span style="color:#2ecc71; font-size:0.7rem; font-weight:800;">ВАШ СЕКРЕТНЫЙ КОД:</span>
                    <span class="code-display"><?= $success_data['code'] ?></span>
                </div>
                <a href="/login.php" class="btn-reg">ВОЙТИ В ИГРУ</a>
            </div>
        <?php else: ?>
            <div class="title-small">Создание героя</div>
            
            <?php if ($error): ?>
                <div class="error-box"><?= $error ?></div>
            <?php endif; ?>

            <form method="POST" action="/reg.php">
                <input type="text" name="login" class="input-field" placeholder="ИМЯ ПЕРСОНАЖА" value="<?= htmlspecialchars($_POST['login'] ?? '') ?>" required>
                <input type="password" name="password" class="input-field" placeholder="ПАРОЛЬ (ОТ 6 СИМВ.)" required>
                
                <div style="text-align:center; margin-bottom:15px;">
                    <img src="/captcha.php?r=<?= rand() ?>" id="captcha_img" style="border-radius:12px; border:1px solid #2ecc71; cursor:pointer;" onclick="this.src='/captcha.php?r='+Math.random();">
                    <p style="font-size:0.7rem; color:#8b949e; margin-top:5px;">Реши пример, чтобы войти</p>
                </div>

                <input type="text" name="captcha" class="input-field" placeholder="ОТВЕТ" required autocomplete="off">
                
                <button type="submit" class="btn-reg">ОБРЕСТИ СИЛУ</button>
            </form>
        <?php endif; ?>
    </div>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
