<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

$error = null;
$success = null;

if (isset($_POST['save'])) {
    $old = $_POST['old_pass'] ?? '';
    $new = $_POST['new_pass'] ?? '';

    if ($old !== $user['pass']) {
        $error = "Текущий пароль неверен";
    } elseif (mb_strlen($new) < 6) {
        $error = "Новый пароль слишком короткий";
    } else {
        $db->prepare("UPDATE `users` SET `pass` = ? WHERE `id` = ?")->execute([$new, $user['id']]);
        $success = "Пароль успешно обновлен!";
    }
}

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .s-container { background: #0f111a; min-height: 100vh; padding: 15px; color: #fff; font-family: 'Inter', sans-serif; }
    .form-card { background: #161b22; border-radius: 25px; padding: 25px; border: 1px solid rgba(255,255,255,0.05); }
    .input-group { margin-bottom: 20px; }
    .input-label { display: block; font-size: 0.7rem; color: #8b949e; text-transform: uppercase; font-weight: 800; margin-bottom: 8px; }
    .input-field { 
        width: 100%; background: #0d1117; border: 1px solid rgba(255,255,255,0.1); 
        padding: 15px; border-radius: 15px; color: #fff; box-sizing: border-box; 
    }
    .btn-save { 
        width: 100%; padding: 18px; border-radius: 18px; border: none; 
        background: #fff; color: #000; font-weight: 800; cursor: pointer; 
    }
    .alert { padding: 15px; border-radius: 15px; margin-bottom: 15px; text-align: center; font-size: 0.85rem; font-weight: 700; }
</style>

<div class="s-container">
    <div style="margin-bottom: 20px;">
        <a href="/settings/" style="color: #00d4ff; text-decoration: none; font-size: 0.9rem;">← Назад</a>
    </div>

    <?php if ($error): ?> <div class="alert" style="background: rgba(255,65,108,0.1); color: #ff416c;"><?= $error ?></div> <?php endif; ?>
    <?php if ($success): ?> <div class="alert" style="background: rgba(46,204,113,0.1); color: #2ecc71;"><?= $success ?></div> <?php endif; ?>

    <div class="form-card">
        <form method="POST">
            <div class="input-group">
                <label class="input-label">Текущий пароль</label>
                <input type="password" name="old_pass" class="input-field" required>
            </div>
            <div class="input-group">
                <label class="input-label">Новый пароль</label>
                <input type="password" name="new_pass" class="input-field" placeholder="Мин. 6 символов" required>
            </div>
            <button type="submit" name="save" class="btn-save">ОБНОВИТЬ ПАРОЛЬ</button>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
