<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

$rename_cost = 500; // Стоимость смены ника в золоте
$error = null;
$success = null;

if (isset($_POST['rename'])) {
    $new_nick = trim($_POST['new_nick'] ?? '');
    
    // 1. Проверка стоимости
    if ($user['gold'] < $rename_cost) {
        $error = "Недостаточно золота (нужно 💰 $rename_cost)";
    } 
    // 2. Валидация ника (длина и символы)
    elseif (mb_strlen($new_nick) < 3 || mb_strlen($new_nick) > 15) {
        $error = "Ник должен быть от 3 до 15 символов";
    } 
    elseif (!preg_match('/^[a-zA-Zа-яА-Я0-9_]+$/u', $new_nick)) {
        $error = "Ник содержит недопустимые символы";
    }
    // 3. Проверка на уникальность
    else {
        $stmt = $db->prepare("SELECT COUNT(*) FROM `users` WHERE `login` = ?");
        $stmt->execute([$new_nick]);
        if ($stmt->fetchColumn() > 0) {
            $error = "Этот ник уже занят другим игроком";
        } else {
            // 4. Проведение оплаты и смена ника
            $db->prepare("UPDATE `users` SET `login` = ?, `gold` = `gold` - ? WHERE `id` = ?")
               ->execute([$new_nick, $rename_cost, $user['id']]);
            
            $user['login'] = $new_nick; // Обновляем в текущей сессии
            $user['gold'] -= $rename_cost;
            $success = "Ваше имя изменено на <b>$new_nick</b>!";
        }
    }
}

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .s-container { background: #0f111a; min-height: 100vh; padding: 15px; color: #fff; font-family: 'Inter', sans-serif; }
    .rename-card { background: #161b22; border-radius: 25px; padding: 25px; border: 1px solid rgba(0, 212, 255, 0.2); box-shadow: 0 10px 30px rgba(0,0,0,0.3); }
    .price-tag { display: inline-block; background: rgba(255, 204, 0, 0.1); color: #ffcc00; padding: 5px 12px; border-radius: 10px; font-weight: 800; font-size: 0.8rem; margin-bottom: 20px; }
    
    .input-field { 
        width: 100%; background: #0d1117; border: 1px solid rgba(255,255,255,0.1); 
        padding: 18px; border-radius: 15px; color: #fff; box-sizing: border-box; 
        font-size: 1rem; text-align: center; font-weight: 700;
    }
    .btn-rename { 
        width: 100%; padding: 18px; border-radius: 18px; border: none; 
        background: linear-gradient(90deg, #00d4ff, #0044ff); color: #fff; 
        font-weight: 800; cursor: pointer; margin-top: 15px; box-shadow: 0 5px 15px rgba(0, 212, 255, 0.3);
    }
    .alert { padding: 15px; border-radius: 15px; margin-bottom: 15px; text-align: center; font-size: 0.85rem; font-weight: 700; }
</style>

<div class="s-container">
    <div style="margin-bottom: 20px;">
        <a href="/settings/" style="color: #586069; text-decoration: none; font-size: 0.9rem;">← Назад</a>
    </div>

    <?php if ($error): ?> <div class="alert" style="background: rgba(255,65,108,0.1); color: #ff416c;"><?= $error ?></div> <?php endif; ?>
    <?php if ($success): ?> <div class="alert" style="background: rgba(46,204,113,0.1); color: #2ecc71;"><?= $success ?></div> <?php endif; ?>

    <div class="rename-card">
        <div style="text-align: center;">
            <div class="price-tag">СТОИМОСТЬ: 💰 <?= $rename_cost ?> золота</div>
            <form method="POST">
                <div style="color: #8b949e; font-size: 0.7rem; text-transform: uppercase; margin-bottom: 10px; font-weight: 800;">Новое имя героя</div>
                <input type="text" name="new_nick" class="input-field" placeholder="Введите ник..." maxlength="15" required>
                <button type="submit" name="rename" class="btn-rename">СМЕНИТЬ ИМЯ</button>
            </form>
            <div style="margin-top: 20px; font-size: 0.65rem; color: #4a4f5a; line-height: 1.4;">
                Допускаются буквы русского и латинского алфавита, цифры и нижнее подчеркивание.
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
