<?php
declare(strict_types=1);

// 1. Запуск сессии (строго один раз и в самом начале)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. Настройки ошибок (убери '1' на '0' когда закончишь отладку)
ini_set('display_errors', '1');
error_reporting(E_ALL);

$start_time = microtime(true);

// 3. Конфигурация БД
$db_config = [
    'host' => 'localhost',
    'name' => 'nex944_bog',
    'user' => 'nex944_bog',
    'pass' => 'qwerty123123',
];

try {
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['name']};charset=utf8mb4";
    $db = new PDO($dsn, $db_config['user'], $db_config['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
} catch (PDOException $e) {
    exit("Ошибка БД: " . $e->getMessage());
}

// 4. Определение текущего пользователя
$user = null;
if (!empty($_SESSION['user_id'])) {
    $stmt = $db->prepare("SELECT * FROM `users` WHERE `id` = ? LIMIT 1");
    $stmt->execute([(int)$_SESSION['user_id']]);
    $user = $stmt->fetch();
    
    if ($user) {
        // Приведение типов для расчетов
        $user['id'] = (int)$user['id'];
        $user['level'] = (int)($user['level'] ?? 1);
        $user['exp'] = (int)($user['exp'] ?? 0);
        $user['exp_next'] = (int)($user['exp_next'] ?? 100);
        
        // Обновляем время последнего визита
        try {
            $db->prepare("UPDATE `users` SET `last_visit` = ? WHERE `id` = ?")
               ->execute([time(), $user['id']]);
        } catch (Exception $e) {
            // Игнорируем если колонки нет
        }
    } else {
        unset($_SESSION['user_id']);
    }
}

// 5. Полезные функции
function noauth(): void {
    global $user;
    if ($user) {
        header("Location: /main.php");
        exit;
    }
}

function time_elapsed(int $timestamp): string {
    if ($timestamp <= 0) return "неизвестно";
    $seconds = time() - $timestamp;
    if ($seconds < 60) return "только что";
    $minutes = (int)floor($seconds / 60);
    if ($minutes < 60) return $minutes . " мин.";
    $hours = (int)floor($minutes / 60);
    return (int)floor($hours / 24) . " дн.";
}

function check_for_levelup(&$user): void {
    global $db;
    if (!is_array($user)) return;

    $up = false;
    while ((int)$user['exp'] >= (int)$user['exp_next'] && (int)$user['exp_next'] > 0) {
        $user['level']++;
        $user['exp'] -= $user['exp_next'];
        $user['exp_next'] = (int)round($user['exp_next'] * 1.15);
        
        $user['str'] += 2;
        $user['agi'] += 2;
        $user['def'] += 2;
        $user['hp_max'] += 20;
        $up = true;
    }

    if ($up) {
        $stmt = $db->prepare("UPDATE `users` SET `level` = ?, `exp` = ?, `exp_next` = ?, `str` = ?, `agi` = ?, `def` = ?, `hp_max` = ? WHERE `id` = ?");
        $stmt->execute([$user['level'], $user['exp'], $user['exp_next'], $user['str'], $user['agi'], $user['def'], $user['hp_max'], $user['id']]);
    }
}

function admin_log(...$args): void {
    global $db, $user;
    
    if (!$user) return;

    // Если в функцию передали два аргумента (базу и текст), берем текст.
    // Если один — берем его.
    $message = '';
    foreach ($args as $arg) {
        if (is_string($arg)) {
            $message = $arg;
            break;
        }
    }

    // Если текст лога не найден среди аргументов, ничего не пишем
    if (empty($message)) return;

    try {
        $stmt = $db->prepare("INSERT INTO `admin_logs` (`user_id`, `action`, `time`) VALUES (?, ?, ?)");
        $stmt->execute([$user['id'], $message, time()]);
    } catch (Exception $e) {
        // Игнорируем ошибки базы данных
    }
}

