<?php
// system/cron/chat_reward.php
require_once __DIR__ . '/../core.php';

$time24 = time() - 86400;

// Ищем самого активного за сутки
$stmt = $db->prepare("
    SELECT user_id, COUNT(id) as cnt 
    FROM `chat_messages` 
    WHERE created_at > ? 
    GROUP BY user_id 
    ORDER BY cnt DESC LIMIT 1
");
$stmt->execute([$time24]);
$winner = $stmt->fetch(PDO::FETCH_ASSOC);

if ($winner) {
    $gold_prize = 5000;
    // Начисляем золото
    $db->prepare("UPDATE `users` SET `gold` = `gold` + ? WHERE `id` = ?")
       ->execute([$gold_prize, $winner['user_id']]);

    // Опционально: можно отправить системное сообщение в чат или личку
    $msg = "Система: Игрок с ID " . $winner['user_id'] . " становится самым активным в чате за сутки и получает 5000 золота!";
    $db->prepare("INSERT INTO `chat_messages` (user_id, message, created_at) VALUES (0, ?, ?)")
       ->execute([$msg, time()]);
}
