<style>
    /* Переменные для стилей */
    :root {
        --bg-color: #0d1117;
        --link-color: #00d4ff;
        --text-color: #e6edf3;
        --separator-color: rgba(255, 255, 255, 0.2);
        --bg-footer: #161b22;
    }

    /* Убедимся, что основной контент не перекрывается футером */
    body {
        padding-bottom: 60px; /* Отступ под футер */
        padding-bottom: calc(60px + env(safe-area-inset-bottom, 0px));
    }

    /* Стили контейнера футера */
    .footer-links {
        background-color: var(--bg-footer);
        border-top: 1px solid var(--separator-color);
        display: flex;
        justify-content: space-around;
        align-items: center;
        height: 50px;
        position: fixed; /* Фиксирует меню внизу экрана */
        bottom: 0;
        left: 0;
        right: 0;
        max-width: 600px; /* Ограничиваем ширину для мобильного вида */
        margin: 0 auto;
        z-index: 1000;
        padding-bottom: env(safe-area-inset-bottom, 0); /* Учет безопасной зоны */
    }

    .footer-link-item {
        display: flex;
        align-items: center;
        justify-content: center;
        flex: 1; /* Равномерно распределяет ссылки */
        text-decoration: none;
        color: var(--text-color);
        font-size: 14px;
        transition: color 0.3s ease;
    }

    .footer-link-item:hover {
        color: var(--link-color);
    }

    .footer-emoji {
        font-size: 18px; /* Уменьшенный размер эмодзи */
        margin-right: 6px; /* Отступ между иконкой и текстом */
    }

    /* Разделители между ссылками */
    .footer-link-item:not(:last-child) {
        border-right: 1px solid var(--separator-color);
    }
</style>

</main> <!-- Закрываем тег main из head.php -->

<footer class="footer-links">
    <!-- Ссылка на Главную -->
    <a href="/main.php" class="footer-link-item">
        <span class="footer-emoji">🏠</span>
        Главная
    </a>
    <!-- Ссылка на Профиль -->
    <a href="/profile.php" class="footer-link-item">
         <span class="footer-emoji">👤</span>
        Профиль
    </a>
    <!-- Ссылка на Клан -->
    <a href="/clan" class="footer-link-item">
         <span class="footer-emoji">🏰</span>
        Клан
    </a>
</footer>



</body>
</html>
