<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Битва Богов — 2026</title>
    
    <!-- Подключение библиотеки иконок Font Awesome (для нижнего меню) -->
    <link rel="stylesheet" href="cdnjs.cloudflare.com">

    <style>
        /* Глобальные переменные темы */
        :root {
            --bg-body: #0d1117;    /* Глубокий темный фон */
            --panel: #161b22;      /* Цвет карточек/шапки */
            --border: rgba(255, 255, 255, 0.1);
            --accent: #00d4ff;     /* Неоновый голубой */
            --text-main: #e6edf3;
            --hp-color: #ff416c;
        }

        /* Базовые настройки страницы и универсальный сброс отступов */
        * { box-sizing: border-box; margin: 0; padding: 0; }
        
        body {
            background-color: var(--bg-body);
            color: var(--text-main);
            font-family: -apple-system, system-ui, sans-serif;
            line-height: 1.4;
            -webkit-tap-highlight-color: transparent; /* Убирает синий блик при нажатии на мобильных */
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            min-height: 100vh;
            border-left: 1px solid var(--border);
            border-right: 1px solid var(--border);
            /* Добавляем отступы с учетом безопасных зон и места под нижнее меню */
            padding: 10px 10px 80px 10px; 
            padding-top: calc(10px + env(safe-area-inset-top, 0px));
            padding-bottom: calc(80px + env(safe-area-inset-bottom, 0px));
        }

        /* Мини-профиль в шапке */
        .top-bar {
            background: var(--panel);
            margin: -10px -10px 15px -10px; 
            padding: 12px 15px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0; 
            z-index: 100;
        }

        .user-mini { display: flex; flex-direction: column; gap: 4px; }
        .user-name { font-weight: bold; font-size: 14px; }
        
        /* Полоска HP */
        .hp-wrap {
            width: 100px;
            height: 6px;
            background: #222;
            border-radius: 3px;
            overflow: hidden;
        }
        .hp-fill {
            height: 100%;
            background: linear-gradient(90deg, #ff4b2b, #ff416c);
            transition: width 0.4s ease;
        }

        .currency { font-size: 13px; font-weight: bold; color: #ffcc00; }
        
        a { color: var(--accent); text-decoration: none; }
        
        main h1, main h2, main p { margin-top: 0; }
    </style>
</head>
<body>
    <div class="container">
        <?php if (isset($user) && $user): ?>
            <header class="top-bar">
                <div class="user-mini">
                    <div class="user-name">
                        <span style="color: var(--accent);">[<?= $user['level'] ?>]</span> <?= htmlspecialchars($user['login']) ?>
                    </div>
                    <div class="hp-wrap">
                        <?php 
                        $hp_p = ($user['hp_max'] > 0) ? ($user['hp_now'] / $user['hp_max'] * 100) : 0; 
                        ?>
                        <div class="hp-fill" style="width: <?= $hp_p ?>%;"></div>
                    </div>
                </div>
                <div class="currency">
                    <?= number_format((int)$user['gold'], 0, '.', ' ') ?> 🟡
                </div>
            </header>
            <main>
                <!-- Ваш основной контент начинается здесь -->
        <?php endif; ?>
<!-- КОНЕЦ ФАЙЛА head.php -->
