<?php
define('NTLCMS', 1);
$module = 'addtask_add';
include ('../system/start.php');
include ('../system/function.php');
include ('../system/antidos.php');
$page_title = 'Страница добавления задания - клик клуба ' . strtoupper($_SERVER['HTTP_HOST']);
include ('../system/head.php');
if (!$active){
header('Location: '.URL);
$_SESSION['fail'] = 'Вы не авторизированы!';
exit;
}
echo '<div class="title"><b>'.razd.' Добавить задание</b></div>';
$error = null;
if (isset($_POST['name']) && isset($_POST['about'])){				
$name = isset($_POST['name']) ? filter_var($_POST['name'], FILTER_SANITIZE_STRING) : false;
$url = isset($_POST['url']) ? filter_var($_POST['url'], FILTER_SANITIZE_STRING) : false;
$about = isset($_POST['about']) ? filter_var($_POST['about'], FILTER_SANITIZE_STRING) : false;
$period = isset($_POST['period']) ? filter_var($_POST['period'], FILTER_SANITIZE_NUMBER_INT) : '0';
$category = isset($_POST['category']) ? filter_var($_POST['category'], FILTER_SANITIZE_NUMBER_INT) : '0';
$info = isset($_POST['info']) ? filter_var($_POST['info'], FILTER_SANITIZE_STRING) : false;
$pay = isset($_POST['pay']) ? filter_var($_POST['pay'], FILTER_SANITIZE_NUMBER_INT) : '0';
if (empty($name)){
$error.= 'Введите название задания!<br/>';
} elseif (mb_strlen($name, 'UTF-8') < 5 or mb_strlen($name, 'UTF-8') > 50){
$error.= 'Название задания должно быть от 5 до 50 символов!!<br/>';
}
if (empty($about)){
$error.= 'Введите описание задания!<br/>';
} elseif (mb_strlen($about, 'UTF-8') < 5 or mb_strlen($about, 'UTF-8') > 1000){
$error.= 'Описание задания должно быть от 10 до 1000 символов!!<br/>';
}
if (empty($info)){
$error.= 'Введите что нужно указать для проверки!<br/>';
} elseif (mb_strlen($info, 'UTF-8') < 5 or mb_strlen($info, 'UTF-8') > 500){
$error.= 'Что нужно указать для проверки должно быть от 10 до 500 символов!!<br/>';
}
if (empty($url)){
$error.= 'Введите ссылку для перехода!<br/>';
} elseif(!preg_match('#[a-zA-Zа-яА-Я0-9_-]{2,300}#i', $url)){
$error.= 'Ссылка для перехода должна быть от 2 до 300 символов!!<br/>';
} elseif (preg_match("/^http:\/\/[a-zA-Z0-9\/.=?_-]+$/", $url)){
$error.= 'Не верно введена ссылка для перехода!<br/>';
}
if (empty($pay)){
$error.= 'Заполните поле Оплата за выполнение!<br/>';
}
if (!DB :: run() -> querySingle("select * from `jobs_category` where `id` = '".$category."'") > 0){
$error.= 'Категория указана неверно!<br/>';
}
if (DB :: run() -> querySingle("select (`time`) from `jobs` where `user` = ? and `time` > ?", array($ulogin, TIME - 180))){
$error.= 'Задание можно добавлять раз в 3 минуты!<br/>';
}
if ($error){
echo '<div class="error"><center><i class="fa fa-close fa-fw"></i> '.$error.'</center></div>';
} else {
if (DB :: run() -> query("insert into `jobs` (`user`, `name`, `url`, `about`, `info`, `category`, `period`, `pay`, `time`) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", array($ilogin, $name, $url, $about, $info, $category, $period, $pay, TIME))){
$_SESSION['success'] = 'Задание успешно добавлено!';
header('Location: '.URL.'/tasks');
} else {
$_SESSION['fail'] = 'Задание не добавлено!';
header('Location: '.URL.'/tasks');
}
}
}
echo '<div class="menu"><form name="form" action="'.URL.'/addtask" method="post">
* <b>Заголовок:</b><br/><input type="text" name="name" maxlength="50"/><br/>
* <b>Категория:</b><br/><select name="category">';
$sql = DB :: run() -> query("select * from `jobs_category`");
while($row = $sql -> fetch(PDO::FETCH_OBJ)){
echo '<option value="'.$row -> id.'">'.$row -> name.'</option>';
}
echo '</select><br/>
* <b>URL выполнения (без http://):</b><br/><input type="text" name="url" maxlength="100"/><br/>				
* <b>Описание:</b><br/><input type="text" name="about" maxlength="1000"/><br/>
* <b>Периодичность:</b><br/><select name="period">
<option value="0">Однократно</option>
<option value="1">Многократно</option>
</select><br/>
* <b>Инфо для выполнения:</b><br/><input type="text" name="info" maxlength="500"/><br/>
* <b>Оплата за выполнение '.coins($row -> pay).' : </b><br/><input type="text" name="pay" maxlength="6"/><br/><br/>
<input type="submit" class="btn btn-success btn-sm" value="Добавить задание"/></form></div>';
echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.URL.'/cabinet">В кабинет</a> | <a href="'.URL.'/tasks">Задания пользователей</a></div>';
include ('../system/foot.php');
?>